// TV51.CPP

#define cmOpen 100

#define  Uses_TFileEditor
#define  Uses_TMenuBar
#define  Uses_TMenuItem
#define  Uses_TSubMenu
#define  Uses_TDeskTop
#define  Uses_TKeys
#define  Uses_TApplication
#include <tv.h>

class Editor : public TApplication
{
  TView *p;

public:
  Editor();

private:
  virtual void handleEvent(TEvent& event);
  static TMenuBar *initMenuBar( TRect r );
};

Editor::Editor() :
    TProgInit(Editor::initStatusLine,
              Editor::initMenuBar,
              Editor::initDeskTop
	     )
{
}

TMenuBar *Editor::initMenuBar( TRect r )
{

      TSubMenu& sub1 = *new TSubMenu( "~F~ile", kbAltF ) +
        *new TMenuItem( "~O~pen", cmOpen, kbF3 ) +
        *new TMenuItem( "~S~ave", cmSave, kbF2, hcNoContext, "F2" ) +
        *new TMenuItem( "~C~lose", cmClose, kbF4, hcNoContext, "F4" ) +
             newLine() +
        *new TMenuItem( "E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X" );

    r.b.y = r.a.y+1;
    return new TMenuBar( r, sub1 );
}

void Editor::handleEvent(TEvent& event)
{
  TProgram::handleEvent(event);
  if (event.what == evCommand)
  {
    switch( event.message.command )
    {
    case cmOpen:

      p = new TFileEditor(TRect(3,3,70,20),
                               NULL,
                               NULL,
                               NULL,
                               "TEST.TXT");
      deskTop->insert(p);
      break;

    default:
      return;
    }
    clearEvent(event);
  }
}

void main(void)
{
  Editor *e = new Editor;
  e->run();
}

