#ifndef __ANSI_H
#define __ANSI_H

#ifndef __STDIO_H
#include <stdio.h>
#include <string.h>
#endif

/* SETSCREEN() Bildschirmmodi
*  0=40x25 mono
*  1=40x25 color
*  2=80x25 mono
*  3=80x25 color
*  4=320x200 color
*  5=320x200 mono
*  6=640x200 mono
*  7=enable word wrap at end of line
* 14=640x200  16 color EGA/VGA, MSDOS 4.0 and later
* 15=640x350   2 color EGA/VGA, MSDOS 4.0 and later
* 16=640x350  16 color EGA/VGA, MSDOS 4.0 and later
* 17=640x480   2 color EGA/VGA, MSDOS 4.0 and later
* 18=640x480  16 color EGA/VGA, MSDOS 4.0 and later
* 19=320x200 256 color EGA/VGA, MSDOS 4.0 and later
*/
#define SETSCREEN(a)         printf("\033[=%uh",a)
/* reset screen graphics mode, Attribut wie SETSCREEN
   a=7: disable word wrap */
#define RESETSCREEN(a)       printf("\033[=%ul",a)

#define ANSI_NORMAL      0
#define ANSI_HIGH        1
#define ANSI_LOW         2
#define ANSI_ITALIC      3
#define ANSI_UNDERLINE   4
#define ANSI_BLINK       5
#define ANSI_FASTBLINK   6
#define ANSI_REVERSE     7
#define ANSI_INVISIBLE   8

#define ANSI_FORE_BLACK   30
#define ANSI_FORE_RED     31
#define ANSI_FORE_GREEN   32
#define ANSI_FORE_YELLOW  33
#define ANSI_FORE_BLUE    34
#define ANSI_FORE_MAGENTA 35
#define ANSI_FORE_CYAN    36
#define ANSI_FORE_WHITE   37

#define ANSI_BACK_BLACK   40
#define ANSI_BACK_RED     41
#define ANSI_BACK_GREEN   42
#define ANSI_BACK_YELLOW  43
#define ANSI_BACK_BLUE    44
#define ANSI_BACK_MAGENTA 45
#define ANSI_BACK_CYAN    46
#define ANSI_BACK_WHITE   47

/* SETDISPLAY()
*
*  Attribut          Vordergrundfarbe  Hintergrundfarbe
*  c                  b                 a
*  0  normal          30 Schwarz        40 Schwarz
*  1  High intensity  31 Rot            41 Rot
*  2  Low intensity   32 Grn           42 Grn
*  3* Italic          33 Gelb           43 Gelb
*  4# Underline       34 Blau           44 Blau
*  5  Blinking        35 Violett        45 Violett
*  6* Rapid blinking  36 Hellblau       46 Hellblau
*  7  Reverse video   37 Wei           47 Wei
*  8  Invisible
* 
*  *  not available
*  #  on monochrome display mode only
*/
#define SETDISPLAY(a,b,c)    printf("\033[%u;%u;%um",a,b,c)

#define VIDHIGH()            SETDISPLAY(0,0,1)
#define VIDBLINK()           SETDISPLAY(0,0,5)
#define VIDNORM()            SETDISPLAY(0,0,0)
#define VIDINVISIBLE()       SETDISPLAY(0,0,8)

#define BEEP()	             printf("\007") /* 800 Hz Ton, 1/4 Sekunde */

/* CLS() lscht den Bildschirm und positioniert den Kursor
   in der linken oberen Bildschirmecke */
#define CLS()        	     printf("\033[2J")

/* EEOL() Lscht die Zeile ab und inklusive der aktuellen Kursorposition */
#define EEOL()               printf("\033[K")

/* Kursorsteuerung */
#define GOTOXY(x,y)          printf("\033[%u;%uH",(x),(y))
#define SETCURPOS(x,y)       GOTOXY(x,y)
#define WHEREXY(x,y)         {VIDINVISIBLE();\
			     rewind(stdin);\
			     printf("\033[6n");\
			     scanf("%*2c%2d%*1c%2d%*2c",(x),(y));\
			     VIDNORM();}
#define GETCURPOS(x,y)       WHEREXY(x,y)

/* Kursorbewegung um eine bestimmte Anzahl von Zeilen/Spalten */
#define CUUP(x)              printf("\033[%uA",(x))
#define CUDN(x)              printf("\033[%uB",(x))
#define CURT(y)              printf("\033[%uC",(y))
#define CULT(y)              printf("\033[%uD",(y))

/* Kursorposition merken und wiederholen */
#define CURSPUSH()           printf("\033[s")
#define CURSPOP()            printf("\033[u")

#define DEVICESTATUS()       printf("\033[6n")

/* Zeichenausgabe */
#define XYCHAR(x,y,z)        printf("\033[%u;%uH%c",(x),(y),(z))
#define XYSTRING(x,y,str)    printf("\033[%u;%uH%s",(x),(y),str)
#define XCTRPRINTF(x,str)    printf("\033[%u;%uH%s",(x),((80-(strlen(str)-1))/2),str)

#define GETKBE()             {int _c;rewind(stdin);_c=getchar();_c++;}
#define GETKB()              {VIDINVISIBLE();\
			     GETKBE();\
			     VIDNORM();}
#define GETCH(c)             {VIDINVISIBLE();\
			     rewind(stdin);\
			     c=getchar();\
			     VIDNORM();}
#define GETCHE(c)            {rewind(stdin);\
			     c=getchar();}
#define GETCHHI(c)           {VIDHIGH();\
			     printf("\b");\
			     GETCHE((c));\
			     VIDNORM();}

#endif /* __ANSI_H */
