#ifndef __HEAP_HPP
#define __HEAP_HPP
/*************************************************/
/* Check class allocation errors.                */
/* Copyright by Joe Schell 1989.	         */
/*************************************************/

#include <iostream.h>
#include <stddef.h>
#include <mytypes.h>

// CHECK_HEAP_diff_:
// Used get around segmented memory on IBMs.
#if defined(__TURBOC__)  \
    && (defined(__LARGE__) ||
        defined(__HUGE__) ||
        defined(__COMPACT__)
       )
  #define CHECK_HEAP_diff_ CHAR huge *
#else
  #define CHECK_HEAP_diff_ CHAR *
#endif

class check_heap
{
public:
  VOID start()
    { begin = new char;	delete begin; }
  check_heap()
    { start(); }

  VOID test(const CHAR *s=0)	// Do a test.
    { end = new char;
      if (begin != end)
	cerr << s
	     << "Heap error: entry/exit difference = "
	     << diff() << ".\n";
      delete end;
    }

  VOID testnew(const CHAR *s=0)	// Do a test and reset.
    { test(s); start(); }

private:
  CHAR *begin, *end; // Beginning and end of allocation

  ptrdiff_t diff() const
  { return (ptrdiff_t)
      ((CHECK_HEAP_diff_)end-(CHECK_HEAP_diff_)begin);
  }

};	// End of check_heap class.

#endif // __HEAP_HPP

