#ifndef __IODEF_H
#define __IODEF_H

// Bitadressen B_... 0xrb
// r...relative Adresse des IO-Bausteins
// b...Bitnummer

#define PC_DMA                  0x000
#define PC_PIC                  0x020
#define PC_PIC_ENABLE           0x021
#define AT_CHIPS_ADR            0x022 /* OUT */
#define AT_CHIPS_DAT            0x023 /* IO */
#define PC_TIM                  0x040
#define PC_KBD_DATA             0x060
#define XT_PPI                  0x060
#define XT_PPI_A                0x060
#define XT_PPI_B                0x061
#define XT_PPI_C                0x062
#define XT_PPI_CMD              0x063
#define AT_KBD_DATA             0x060
#define AT_KBD_CMD              0x064
#define AT_CMOS_ADR             0x070
#define AT_CMOS_DAT             0x071
#define AT_NMI_MASK             0x070
#define AT_DIAG                 0x080
#define PC_DMAPG_0              0x080
#define PC_DMAPG_1              0x081
#define PC_DMAPG_2              0x082
#define PC_DMAPG_3              0x083
#define PC_NMI_MASK             0x0a0
#define AT_PIC                  0x0a0
#define AT_DMA                  0x0c0
#define AT_287_LATCH_CLEAR      0x0f0
#define AT_287_RESET            0x0f1
#define AT_287_DATA             0x0f8
#define AT_HD1                  0x1f0
#define PC_GAME                 0x200
#define XT_EXPANSION            0x210
#define PC_LPT3                 0x278
#define PC_EGA2                 0x2c0
#define PC_COM4                 0x2e8
#define PC_COM2                 0x2f8
#define PC_PROTOTYPE            0x300
#define XT_HD                   0x320
#define PC_FD2                  0x370
#define PC_LPT2                 0x378
#define PC_SDLC1                0x380
#define PC_MDA1                 0x3b0
#define PC_LPT1                 0x3bc
#define PC_EGA1                 0x3c0
#define PC_CGA                  0x3d0
#define PC_COM3                 0x3e8
#define PC_FD1                  0x3f0
#define PC_COM1                 0x3f8

/* LPT */
#define LPT_DATA  0
#define LPT_STATUS 1
#define LPT_CTRL  2
#define B_LPT_ERROR             0x14
#define B_LPT_PAPER             0x15
#define B_LPT_ACK               0x16
#define B_LPT_BUSY              0x17
#define B_LPT_STROBE            0x20
#define B_LPT_AUTOFEED          0x21
#define B_LPT_INIT              0x22
#define B_LPT_SELECT            0x23

/* COM */
#define COM_DATA         0 /* DLAB=0 */
#define COM_IEN          1 /* DLAB=0 */
#define COM_DIV_LSB      0 /* DLAB=1 */
#define COM_DIV_MSB      1 /* DLAB=1 */
#define COM_IID          2
#define COM_CONTROL      3
#define COM_MODEM        4
#define COM_LINE_STATUS  5
#define COM_MODEM_STATUS 6
#define B_COM_LINE_DCD          0x67
#define B_COM_LINE_RI           0x66
#define B_COM_LINE_DSR          0x65
#define B_COM_LINE_CTS          0x64
#define B_COM_LINE_DDCD         0x63
#define B_COM_LINE_DRI          0x62
#define B_COM_LINE_DDSR         0x61
#define B_COM_LINE_DCTS         0x60
#define B_COM_LINE_TX           0x56
#define B_COM_LINE_TH           0x55
#define B_COM_LINE_BREAK        0x54
#define B_COM_LINE_FE           0x53
#define B_COM_LINE_PE           0x52
#define B_COM_LINE_OR           0x51
#define B_COM_LINE_RX           0x50
#define B_COM_MODEM_LOOP        0x44
#define B_COM_MODEM_OUT2        0x43
#define B_COM_MODEM_OUT1        0x42
#define B_COM_MODEM_RTS         0x41
#define B_COM_MODEM_DTR         0x40
#define B_COM_CONTROL_DLAB      0x37
#define B_COM_CONTROL_BREAK     0x36
#define B_COM_IID               0x20  /* 0=Interrupt */
#define B_COM_IEN_MODEM         0x13  /* DLAB=0 */
#define B_COM_IEN_LINE          0x12  /* DLAB=0 */
#define B_COM_IEN_TX            0x11  /* DLAB=0 */
#define B_COM_IEN_RX            0x10  /* DLAB=0 */

/* XT-EXPANSION */
#define XT_EXPANSION_CONTROL       0
#define XT_EXPANSION_ENABLE        3
#define XT_EXPANSION_DATA          5
#define XT_EXPANSION_ADDRESS_HIGH  5
#define XT_EXPANSION_ADDRESS_LOW   6

/* TIMER */
#define TIM_CH0 0
#define TIM_CH1 1
#define TIM_CH2 2
#define TIM_CTL 3

/* PPI 8055 */
#define PPI_A   0
#define PPI_B   1
#define PPI_C   2
#define PPI_CMD 3
/* A */ /* IN */
/* Keyboard-Data */

/* B */
#define B_PPI_KBDENABLE      0x17
#define B_PPI_KBDCLOCKLOW    0x16
#define B_PPI_IOCHECKENABLE  0x15
#define B_PPI_RAMCHECKENABLE 0x14
#define B_PPI_DIPSWITCH      0x13
#define B_PPI_TIM2DATA       0x11
#define B_PPI_TIM2GATE       0x10

/* C */
#define B_PPI_RAMCHK         0x27 /* IN */
#define B_PPI_IOCHK          0x26 /* IN */
#define B_PPI_TIM2OUT        0x25 /* IN */
#define B_PPI_REFRESH        0x24 /* IN */
#define B_PPI_DIP3           0x23 /* IO */
#define B_PPI_DIP2           0x22 /* IO */
#define B_PPI_DIP1           0x21 /* IO */
#define B_PPI_DIP0           0x20 /* IO */

#endif //__IODEF_H
