#ifndef __MYHIST_HPP
#define __MYHIST_HPP

#include <mytypes.h>
#include <keybios.hpp>

const LEN=10;

class KBDHISTORY
{
  class KBDHISTORY_INDEX
  {
  private:
    INT val;
  public:
    KBDHISTORY_INDEX() { val=0; }
    INT operator ++ ()
      { val++; if (val==LEN) val=0; return val;
      }
    INT operator -- ()
      { val--; if (val==-1) val=LEN-1; return val;
      }
    INT operator () () { return val; }
    VOID operator = (INT v) { val=v; }
  };

private:

  KBDSTATUS *queue[LEN];
  KBDHISTORY_INDEX *head; // next event to be written
  KBDHISTORY_INDEX *tail; // next event to get
  INT count;

public:

  KBDHISTORY();
  ~KBDHISTORY();

  KBDSTATUS *operator()();
  BOOL put(KBDSTATUS *s);
  KBDSTATUS *get();
  INT size() { return count; }
};

#endif
