
#ifndef __KEY_HPP
#define __KEY_HPP

#include <stddef.h>

#define  AT_NEU
#undef   AT_ALT

void  poke40(unsigned,unsigned);
unsigned  peek40(unsigned);
unsigned char peekb40(unsigned);

#define KEYBD_status        0x17
#define KEYBD_buffer_head   0x1a
#define KEYBD_buffer_tail   0x1c
#define KEYBD_buffer_end    0x82
#define KEYBD_buffer_start  0x80

#define FLAGS_zero_bit      0x0040

#define KEY_CODE_ACK    0xfa // kann ignoriert werden
#define KEY_CODE_RESEND 0xfe // kann ignoriert werden
#define KEY_CODE_CUUP   0x48 // Cursor-Up          
#define KEY_CODE_CUDN   0x50 // Cursor-Down        
#define KEY_CODE_SHIFTL 0x2a // Linke Shifttaste   
#define KEY_CODE_SHIFTR 0x36 // Rechte Shifttaste  

#ifdef AT_ALT
#define KEY_CODE_EXT0   0xb5 // leitet Extended-Taste ein (alte KEY-Controller)
#define KEY_CODE_EXT1   0x95 // leitet Extended-Taste ein (alte KEY-Controller)
#define SCAN_PAUSE      "\x95\x1d\x45\x95\x9d\xc5"
#endif
#ifdef AT_NEU
#define KEY_CODE_EXT0   0xe0 // leitet Extended-Taste ein
#define KEY_CODE_EXT1   0xe1 // leitet Extended-Taste ein (nur Pause)
#define SCAN_PAUSE[]    "\xe1\x1d\x45\xe1\x9d\xc5"
#endif

// besondere Tastenfolgen
// 0xe1 0x1d 0x45 0xe1 0x9d 0xc5  PAUSE
// 0xe0 0x2a 0xe0 0x37 0xe0 0xb7 0xe0 0xaa  DRUCK

void popmain();

#endif 

