
#ifndef __TINY__
  #error must use TINY model
#endif
#ifndef __BORLANDC__
  #error must use BORLAND-Compiler
#endif

#include <dos.h>
#include <bios.h>
#include <string.h>
#include <stdio.h>
#define P_SOUND
#include <portable.h>

char  tsr_fprint[20] = "tsr.v1";  /* unique string*/

/* reduce heaplength and stacklength to make a smaller program in memory */
extern unsigned _heaplen = 256;
extern unsigned _stklen  = 1024;
unsigned tsr_psp;

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif

void send_key(unsigned key)
{
  sendstring="K1234";
  sethex(&sendstring[1],(key&0xff00)>>8);
  sethex(&sendstring[3],key&0x00ff);
}

void interrupt ( *oldint_keyb )(__CPPARGS);

void interrupt newint_keyb(__CPPARGS)
{
  unsigned Taste;
  oldint_keyb();
  Taste = bioskey(0x11);
  if (Taste)
  {
    if ((Taste&0xff)==0x1b)
    {
      sound_beep(1000);
    }
  bioskey(0);
  send_key(Taste);
}

unsigned tsr_already_in(void)
{
  int tsr_hit = 0;
  unsigned tsr_ds;
  char far *mycopy=(char far *)MK_FP(_DS,tsr_fprint);
  int fprint_length = strlen(tsr_fprint);
  unsigned fprint_offset=(unsigned)(&tsr_fprint);
  tsr_ds=0x900; // start searching at
  while((tsr_ds < _DS) && tsr_hit==0)
  {
    if (_fmemcmp(mycopy,MK_FP(tsr_ds,fprint_offset),fprint_length)==0)
      tsr_hit=1;
    else
      tsr_ds+=1;
  }

  if(tsr_hit==1)
     return(tsr_ds);
  else
     return 0;
}

int tsr_install(void)
{
  if (tsr_already_in()) return 1;
  // remember old psp
  tsr_psp = _psp;
  disable();
  oldint_keyb=getvect(0x09);
  setvect(0x09,newint_keyb);
  enable();
  _dos_keep(0, (_SS + (_SP/16) - _psp));
  return 0;
}

int tsr_uninstall(void)
{
  unsigned tsr_ds=tsr_already_in();
  if (tsr_ds == 0) return (2);

  {
    char far *fp = (char far *)MK_FP(tsr_ds,&tsr_psp);
    tsr_psp = *((unsigned far *)fp);
  }

  { // restore interruptvectors
    _fmemcpy(MK_FP(0,0x09*4),MK_FP(tsr_ds,&oldint_keyb),4);
  }

  { // search for resident memory block
    unsigned cseg,pid,mlen;
    _fmemcpy(MK_FP(_DS,&cseg),MK_FP(0,0xba),2); // INT = 0x2E
    cseg-=1;

    for (;;)
    { // walk through memory chain
      char far *p=(char far *)MK_FP(cseg,0);
      if (*p != 'M') break;
      p++;
      pid=*(unsigned far *)p;
      p++; p++;
      mlen=*(unsigned far *)p;
      cseg+=1;
      if(pid == tsr_psp)
      { // free memory
        union REGS r;
        struct SREGS sr;
        sr.es=cseg;
        r.h.ah=0x49;
        intdosx(&r,&r,&sr);
      }
      cseg+=mlen;
    }
  }
  return (0);
}

void main(int argc,char *argv[])
{
  int return_value;

  switch (argc)
  {
  default: printf("Only arguments /i or /r allowed\n");
	   return;
  case 2:
    if (!((argv[1][0]=='/')||(argv[1][0]=='-')))
    {
      printf("Argument starting with '/' or '-'\n");
      return;
    }
    if (strlen(argv[1])!=2)
    {
      printf("Wrong argumentlength\n");
      return;
    }
    if ((argv[1][1]=='r') || (argv[1][1]=='R'))
    {
      return_value = tsr_uninstall();
      switch (return_value)
      {
      case 0 : printf("%s successfully removed\n",__FILE__); return;
      case 2 : printf("%s not loaded\n",__FILE__); return;
      case 3:  printf("Other programs loaded above %s\n",__FILE__); return;
      }
    }
    else if ((argv[1][1]=='i') || (argv[1][1]=='I'))
    {
      printf("Installing %s\n",__FILE__);
      return_value = tsr_install();
      switch (return_value)
      {
      case 1 : printf("%s already installed\n",__FILE__); return;
      }
    }
  }
}

