#undef SERIAL

#ifndef __TINY__
  #error must use TINY model
#endif
#ifndef __TURBOC__
  #error must use BORLAND-Compiler
#endif

//#pragma option -N- // turn off stack-overflow-checking

#ifdef SERIAL
#include <gfcpp_os.hpp>
#include <serial.hpp>

#ifdef GF_OS2
  GFComOS2 sio( COM2 );
#else
  GFI8250 sio( COM2, 0x2f8, IRQ3, 300, 300 );
#endif
  GFSerial cp( &sio );
#endif

#include <dos.h>
#include <bios.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>

char  tsr_fprint[20] = "tsr.v1";  /* unique string*/

/* reduce heaplength and stacklength to make a smaller program in memory */
// extern unsigned _heaplen = 256;
// extern unsigned _stklen  = 1024;
unsigned tsr_psp;
volatile int tsr_reqflag=0;
unsigned tsr_dosseg;
unsigned tsr_dosoff;
volatile tsr_running=0;
volatile tsr_lastkey;

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif

const unsigned STACKLEN=5000;
static char temporary_stack[STACKLEN];
static unsigned old_stackp;
static unsigned old_stacks;
#if 0

#define NEWSTACK(); \
  asm   cli;\
  asm   mov ax,cs;\
  asm   mov es,ax;\
  asm   mov ds,ax;\
  asm   mov old_stackp,sp;\
  asm   mov ax,ss;\
  asm   mov old_stacks,ax;\
  asm   mov ax,cs;\
  asm   mov ss,ax;\
  asm   mov sp,OFFSET temporary_stack;\
  asm   add sp,STACKLEN-1;\
  asm   sti

#define OLDSTACK();  \
  asm   cli;\
  asm   mov ax,old_stackp;\
  asm   mov bx,old_stacks;\
  asm   mov ss,bx;\
  asm   mov sp,ax;\
  asm   sti
#endif

void get_dosaddr(void)
{
  union REGS r;
  struct SREGS sr;
  r.x.ax=0x34;
  intdosx(&r,&r,&sr);
  tsr_dosseg=sr.es;
  tsr_dosoff=r.x.bx;
}

void sendkey()
{
  unsigned char sendstring[]="K1234";
  itoa((tsr_lastkey&0xff00)>>8,(char *)&sendstring[1],16);
  itoa(tsr_lastkey&0xff,(char *)&sendstring[3],16);
#ifdef SERIAL
  cp << sendstring;
  cout << sendstring << endl;
#endif
  unsigned char far *cp =
    (unsigned char far *)MK_FP(0xb800,0);
  *cp=sendstring[0]; cp++; cp++;
  *cp=sendstring[1]; cp++; cp++;
  *cp=sendstring[2]; cp++; cp++;
  *cp=sendstring[3]; cp++; cp++;
  *cp=sendstring[4]; cp++; cp++;
}

void interrupt ( *oldint_disk)(__CPPARGS);
void interrupt ( *oldint_tick)(__CPPARGS);
void interrupt ( *oldint_keyb)(__CPPARGS);
void interrupt ( *oldint_v28)(__CPPARGS);

void interrupt newint_tick(__CPPARGS)
{
#if 0
  asm {
    // make TINY conditions cs=ds=es
    mov ax,cs
    mov es,ax
    mov ds,ax
    mov ss,ax
    }
#endif
  oldint_tick();
#if 0
  if (tsr_reqflag)
  {
//    char far *p = (char far *)MK_FP(tsr_dosseg,tsr_dosoff);
//    if (*p==0)
//    { // do popup-function
      sendkey(); //asm int 28h
//    }
//    else
//    { // occupied
//      sound(1000);delay(300);nosound();
//    }
    tsr_reqflag=0;
  }
#endif
}

void interrupt newint_keyb(__CPPARGS)
{
  unsigned Taste;
  oldint_keyb();
  Taste = bioskey(0x11);
  if (Taste)
  {
    if ((Taste&0xff)==0x1b)
    {
      sound(1000);delay(300);nosound();
      bioskey(0);
    }
  }
//  while (tsr_reqflag) ;
  tsr_lastkey=Taste;
  tsr_reqflag=1;
}

void interrupt newint_disk(__CPPARGS)
{
  oldint_disk();
}

#if 0
char localdta[130];

void tsr_dta_on()
{
  asm {
	push	bp
	push	ax
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
      }
  REGS r; SREGS sr;
  r.h.ah=0x2f;
  intdosx(&r,&r,&sr);
  dtaes=sr.es;
  dtabx=s.x.bx;

  r.x.dx=(unsigned)&localdta[0];
  r.h.ah=0x1a;
  intdos(&r,&r);

  mov r.x.ax=0x3524;
  intdosx(&r,&r,&sr);

}
#endif

void interrupt newint_v28(__CPPARGS)
{
#if 0
  asm   cli
  asm   mov ax,cs
  asm   mov es,ax
  asm   mov ds,ax
  asm   mov old_stackp,sp
  asm   mov ax,ss
  asm   mov old_stacks,ax
  asm   mov ax,cs
  asm   mov ss,ax
  asm   mov sp,OFFSET temporary_stack
  asm   add sp,STACKLEN-1
;  asm   sti
#endif
  oldint_v28();
#if 0
;  asm   cli
  asm   mov ax,old_stackp
  asm   mov bx,old_stacks
  asm   mov ss,bx
  asm   mov sp,ax
  asm   sti
#endif
#if 0
  return;

  if (tsr_running) return;

  if ((tsr_reqflag==0) || (tsr_running==1))
      return;

  tsr_running=1;

//  tsr_dta_on();
  sendkey();
//  tsr_dta_off();

  tsr_running=0;
#endif
}

unsigned tsr_already_in(void)
{
  int tsr_hit = 0;
  unsigned tsr_ds;
  char far *mycopy=(char far *)MK_FP(_DS,tsr_fprint);
  int fprint_length = strlen(tsr_fprint);
  unsigned fprint_offset=(unsigned)(&tsr_fprint);
  tsr_ds=0x900; // start searching at
  while((tsr_ds < _DS) && tsr_hit==0)
  {
    if (_fmemcmp(mycopy,MK_FP(tsr_ds,fprint_offset),fprint_length)==0)
      tsr_hit=1;
    else
      tsr_ds+=1;
  }

  if(tsr_hit==1)
     return(tsr_ds);
  else
     return 0;
}

int tsr_install(void)
{
  if (tsr_already_in()) return 1;
//  get_dosaddr();
  // remember old psp
  tsr_psp = _psp;
  disable();
//  oldint_tick=getvect(0x08);
  oldint_keyb=getvect(0x09);
//  oldint_disk=getvect(0x13);
//  oldint_disk=getvect(0x28);
//  setvect(0x08,newint_tick);
  setvect(0x09,newint_keyb);
//  setvect(0x13,newint_disk);
//  setvect(0x28,newint_v28);
  enable();
  _dos_keep(0, (_SS + (_SP/16) - _psp));
  return 0;
}

int tsr_uninstall(void)
{
  unsigned tsr_ds=tsr_already_in();
  if (tsr_ds == 0) return (2);

  {
    char far *fp = (char far *)MK_FP(tsr_ds,&tsr_psp);
    tsr_psp = *((unsigned far *)fp);
  }

  { // restore interruptvectors
//    _fmemcpy(MK_FP(0,0x08*4),MK_FP(tsr_ds,&oldint_tick),4);
    _fmemcpy(MK_FP(0,0x09*4),MK_FP(tsr_ds,&oldint_keyb),4);
//    _fmemcpy(MK_FP(0,0x13*4),MK_FP(tsr_ds,&oldint_disk),4);
//    _fmemcpy(MK_FP(0,0x28*4),MK_FP(tsr_ds,&oldint_v28),4);
  }

  { // search for resident memory block
    unsigned cseg,pid,mlen;
    _fmemcpy(MK_FP(_DS,&cseg),MK_FP(0,0xba),2); // INT = 0x2E
    cseg-=1;

    for (;;)
    { // walk through memory chain
      char far *p=(char far *)MK_FP(cseg,0);
      if (*p != 'M') break;
      p++;
      pid=*(unsigned far *)p;
      p++; p++;
      mlen=*(unsigned far *)p;
      cseg+=1;
      if(pid == tsr_psp)
      { // free memory
        union REGS r;
        struct SREGS sr;
        sr.es=cseg;
        r.h.ah=0x49;
        intdosx(&r,&r,&sr);
      }
      cseg+=mlen;
    }
  }
  return (0);
}

void main(int argc,char *argv[])
{
#if 0
  for(;;)
  {
    unsigned Taste=bioskey(0);
    if (Taste==0x011b) return;
    sendkey(Taste);
  }
#endif
  int return_value;

#ifdef SERIAL
  if (!(&sio) || !(&cp))
  {
    cout << "Error building serial connection" << endl;
    return;
  }
#endif

  switch (argc)
  {
  default:
    cout << "Only arguments /i or /r allowed" << endl;
    return;
  case 2:
    if (!((argv[1][0]=='/')||(argv[1][0]=='-')))
    {
      cout << "Argument starting with '/' or '-'" << endl;
      return;
    }
    if (strlen(argv[1])!=2)
    {
      cout << "Wrong argumentlength" << endl;
      return;
    }
    if ((argv[1][1]=='r') || (argv[1][1]=='R'))
    {
      return_value = tsr_uninstall();
      switch (return_value)
      {
      case 0 :
        cout << __FILE__ << " successfully removed" << endl;
        return;
      case 2 :
        cout << __FILE__ << " not loaded" << endl;
        return;
      case 3:
        cout << "Other programs loaded above " << __FILE__ << endl;
        return;
      }
    }
    else if ((argv[1][1]=='i') || (argv[1][1]=='I'))
    {
      cout << "Installing " << __FILE__ << endl;
      return_value = tsr_install();
      switch (return_value)
      {
      case 1 :
        cout << __FILE__ << "already installed" << endl;
        return;
      }
    }
  }
}

