
#ifndef __TINY__
  #error must use TINY model
#endif
#ifndef __TURBOC__
  #error must use BORLAND-Compiler
#endif

#pragma option -N- // turn off stack-overflow-checking

#include <dos.h>
#include <bios.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>

char  tsr_fprint[20] = "tsr.v1";  /* unique string*/

/* reduce heaplength and stacklength to make a smaller program in memory */
extern unsigned _heaplen = 512;
extern unsigned _stklen  = 4096;

unsigned tsr_psp;
volatile int tsr_reqflag=0;
unsigned tsr_dosseg;
unsigned tsr_dosoff;
volatile tsr_running=0;
volatile tsr_lastkey;

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif

const unsigned STACKLEN=5000;
static char temporary_stack[STACKLEN];
static unsigned old_stackp;
static unsigned old_stacks;

#define NEWSTACK(); \
  asm   cli;\
  asm   mov ax,cs;\
  asm   mov ds,ax;\
  asm   mov old_stackp,sp;\
  asm   mov ax,ss;\
  asm   mov old_stacks,ax;\
  asm   mov ax,cs;\
  asm   mov ss,ax;\
  asm   mov sp,OFFSET temporary_stack;\
  asm   add sp,STACKLEN-1;\
  asm   sti

#define OLDSTACK();  \
  asm   cli;\
  asm   mov ax,old_stackp;\
  asm   mov sp,ax;\
  asm   mov ax,old_stacks;\
  asm   mov ss,ax;\
  asm   sti

static volatile unsigned char sendstring[]="K1234";
static unsigned char far *vp;
static volatile unsigned Taste;
char *hexc = "0123456789ABCDEF";

void interrupt ( *oldint_keyb)(__CPPARGS);
void interrupt newint_keyb(__CPPARGS)
{
  NEWSTACK();
  oldint_keyb();
  Taste = bioskey(0x11);
  if (Taste)
  {
    sendstring[1]=hexc[(Taste&0xf000)>>12];
    sendstring[2]=hexc[(Taste&0x0f00)>>8];
    sendstring[3]=hexc[(Taste&0x00f0)>>4];
    sendstring[2]=hexc[Taste&0x000f];
    vp = (unsigned char far *)MK_FP(0xb800,0);
    *vp=sendstring[0]; vp++; vp++;
    *vp=sendstring[1]; vp++; vp++;
    *vp=sendstring[2]; vp++; vp++;
    *vp=sendstring[3]; vp++; vp++;
    *vp=sendstring[4];
  }
  OLDSTACK();
}

unsigned tsr_already_in(void)
{
  int tsr_hit = 0;
  unsigned tsr_ds;
  char far *mycopy=(char far *)MK_FP(_DS,tsr_fprint);
  int fprint_length = strlen(tsr_fprint);
  unsigned fprint_offset=(unsigned)(&tsr_fprint);
  tsr_ds=0x900; // start searching at
  while((tsr_ds < _DS) && tsr_hit==0)
  {
    if (_fmemcmp(mycopy,MK_FP(tsr_ds,fprint_offset),fprint_length)==0)
      tsr_hit=1;
    else
      tsr_ds+=1;
  }

  if(tsr_hit==1)
     return(tsr_ds);
  else
     return 0;
}

int tsr_install(void)
{
  if (tsr_already_in()) return 1;
//  get_dosaddr();
  tsr_psp = _psp;    // remember old psp
  disable();
  oldint_keyb=getvect(0x09);
  setvect(0x09,newint_keyb);
  enable();
  _dos_keep(0, (_SS + (_SP/16) - _psp));
  return 0;
}

int tsr_uninstall(void)
{
  unsigned tsr_ds=tsr_already_in();
  if (tsr_ds == 0) return (2);

  {
    char far *fp = (char far *)MK_FP(tsr_ds,&tsr_psp);
    tsr_psp = *((unsigned far *)fp);
  }

  { // restore interruptvectors
    _fmemcpy(MK_FP(0,0x09*4),MK_FP(tsr_ds,&oldint_keyb),4);
  }

  { // search for resident memory block
    unsigned cseg,pid,mlen;
    _fmemcpy(MK_FP(_DS,&cseg),MK_FP(0,0xba),2); // INT = 0x2E
    cseg-=1;

    for (;;)
    { // walk through memory chain
      char far *p=(char far *)MK_FP(cseg,0);
      if (*p != 'M') break;
      p++;
      pid=*(unsigned far *)p;
      p++; p++;
      mlen=*(unsigned far *)p;
      cseg+=1;
      if(pid == tsr_psp)
      { // free memory
        union REGS r;
        struct SREGS sr;
        sr.es=cseg;
        r.h.ah=0x49;
        intdosx(&r,&r,&sr);
      }
      cseg+=mlen;
    }
  }
  return (0);
}

void main(int argc,char *argv[])
{
#if 0
  for(;;)
  {
    unsigned Taste=bioskey(0);
    if (Taste==0x011b) return;
    tsr_lastkey=Taste;
    sendkey();
  }
#endif
  int return_value;

  switch (argc)
  {
  default:
    cout << "Only arguments /i or /r allowed" << endl;
    return;
  case 2:
    if (!((argv[1][0]=='/')||(argv[1][0]=='-')))
    {
      cout << "Argument starting with '/' or '-'" << endl;
      return;
    }
    if (strlen(argv[1])!=2)
    {
      cout << "Wrong argumentlength" << endl;
      return;
    }
    if ((argv[1][1]=='r') || (argv[1][1]=='R'))
    {
      return_value = tsr_uninstall();
      switch (return_value)
      {
      case 0 :
        cout << __FILE__ << " successfully removed" << endl;
        return;
      case 2 :
        cout << __FILE__ << " not loaded" << endl;
        return;
      case 3:
        cout << "Other programs loaded above " << __FILE__ << endl;
        return;
      }
    }
    else if ((argv[1][1]=='i') || (argv[1][1]=='I'))
    {
      cout << "Installing " << __FILE__ << endl;
      return_value = tsr_install();
      switch (return_value)
      {
      case 1 :
        cout << __FILE__ << "already installed" << endl;
        return;
      }
    }
  }
}

