
#ifndef __TINY__
  #error must use TINY model
#endif
#ifndef __TURBOC__
  #error must use BORLAND-Compiler
#endif

#pragma option -N- // turn off stack-overflow-checking

#include <dos.h>
#include <bios.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <iodef.h>
#include <memabs.hpp>

char  tsr_fprint[20] = "tsr.v1";  /* unique string*/

/* reduce heaplength and stacklength to make a smaller program in memory */
extern unsigned _heaplen = 512;
extern unsigned _stklen  = 4096;

static unsigned tsr_psp;

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif

const unsigned STACKLEN=5000;
static char temporary_stack[STACKLEN];
static unsigned old_stackp;
static unsigned old_stacks;

#define NEWSTACK(); \
  asm   cli;\
  asm   mov ax,cs;\
  asm   mov ds,ax;\
  asm   mov old_stackp,sp;\
  asm   mov ax,ss;\
  asm   mov old_stacks,ax;\
  asm   mov ax,cs;\
  asm   mov ss,ax;\
  asm   mov sp,OFFSET temporary_stack;\
  asm   add sp,STACKLEN-1;\
  asm   sti

#define OLDSTACK();  \
  asm   cli;\
  asm   mov ax,old_stackp;\
  asm   mov sp,ax;\
  asm   mov ax,old_stacks;\
  asm   mov ss,ax;\
  asm   sti

static volatile unsigned char sendstring[]="K1234";
static volatile unsigned Taste;
char *hexc = "0123456789ABCDEF";

void interrupt ( *oldint_tick)(__CPPARGS);
void interrupt ( *oldint_keyb)(__CPPARGS);
void interrupt ( *oldint_com2)(__CPPARGS);

// used to manage the com2-tx-buffer
#define TXBUF 10
static volatile int sending=0;
static unsigned char txb[TXBUF];
static volatile unsigned char *tx_head=txb;
static volatile unsigned char *tx_tail=txb;
static unsigned char *tx_beg=txb;
static unsigned char *tx_end=txb+TXBUF;

// used to manage the com2-rx-buffer
#define RXBUF 10
static unsigned char rxb[RXBUF];
static volatile unsigned char *rx_head=rxb;
static volatile unsigned char *rx_tail=rxb;
static unsigned char *rx_beg=rxb;
static unsigned char *rx_end=rxb+RXBUF;
volatile static enum RXSTATE
{
  WAITING,
  KEYDATA
} rxstate = WAITING;

#define KEYCOUNT 4
static volatile int keycount;
static volatile unsigned char rx_data[KEYCOUNT];

void interrupt newint_tick(__CPPARGS)
{
  oldint_tick();
  if (rx_head==rx_tail)
  {
    return;
  }
  switch (rxstate)
  {
  case WAITING:
    switch (*rx_head)
    {
    case 'K':
      rxstate=KEYDATA;
      keycount=0;
    default:
      break;
    }
    break;
  case KEYDATA:
    rx_data[keycount]=*rx_head;
    keycount++;
    if (keycount==KEYCOUNT)
    {
      rxstate=WAITING;
      unsigned char far *kbtail=
        (unsigned char far *)MK_FP(0x40,0x1c);
      unsigned char far *q=
        (unsigned char far *)MK_FP(0x40,*kbtail);
      *q=(strchr(hexc,rx_data[3])-&hexc[0])+
         (strchr(hexc,rx_data[2])-&hexc[0])*16;
      q++;
      *q=(strchr(hexc,rx_data[1])-&hexc[0])+
         (strchr(hexc,rx_data[0])-&hexc[0])*16;
      q++;
      if (FP_OFF(q)==0x3e) *kbtail=0x1e;
      else *kbtail=FP_OFF(q);
    }
    break;
  }
}

void interrupt newint_keyb(__CPPARGS)
{
//  NEWSTACK();
  oldint_keyb();
  disable();
  Taste = bioskey(0x11);
  if (Taste)
  {
    sendstring[1]=hexc[(Taste&0xf000)>>12];
    sendstring[2]=hexc[(Taste&0x0f00)>>8];
    sendstring[3]=hexc[(Taste&0x00f0)>>4];
    sendstring[4]=hexc[Taste&0x000f];
    { // for testing only
      unsigned char far *vp
        = (unsigned char far *)MK_FP(0xb800,0);
      *vp=sendstring[0]; vp++; vp++;
      *vp=sendstring[1]; vp++; vp++;
      *vp=sendstring[2]; vp++; vp++;
      *vp=sendstring[3]; vp++; vp++;
      *vp=sendstring[4];
    }
    for (int i=0; i<5; i++)
    { // put into buffer
      *tx_tail=sendstring[i];
      tx_tail++;
      if (tx_tail==tx_end)
        tx_tail=tx_beg;
    }
    if (!sending)
    {
      sending=1;
      outp(PC_COM2,*tx_head);
      tx_head++;
      if (tx_head==tx_end)
        tx_head=tx_beg;
    }
  } // Taste
//  OLDSTACK();
  enable();
}

void interrupt newint_com2(__CPPARGS)
{
  disable();
  unsigned char status;
  status=inp(PC_COM2+2); // Int.Id
  switch (status&0x7)
  {
  case 00: // MODEM
    break;
  case 02: // TX
    if (tx_head==tx_tail)
    {
      sending=0;
    }
    else
    {
      sending=1;
      outp(PC_COM2,*tx_head);
      {
        unsigned char far *vp
          = (unsigned char far *)MK_FP(0xb800,80);
        vp+=2*(unsigned)(tx_head-tx_beg);
        *vp=*tx_head;
      }
      tx_head++;
      if (tx_head==tx_end) tx_head=tx_beg;
    }
    break;
  case 04: // RX
    *rx_tail=inp(PC_COM2);
    rx_tail++; if (rx_tail==rx_end) rx_tail=rx_beg;
    break;
  case 06: // LINE
    break;
  }
  outp(PC_PIC,0x20);
  enable();
}

unsigned tsr_already_in(void)
{
  int tsr_hit = 0;
  unsigned tsr_ds;
  char far *mycopy=(char far *)MK_FP(_DS,tsr_fprint);
  int fprint_length = strlen(tsr_fprint);
  unsigned fprint_offset=(unsigned)(&tsr_fprint);
  tsr_ds=0x900; // start searching at
  while((tsr_ds < _DS) && tsr_hit==0)
  {
    if (_fmemcmp(mycopy,MK_FP(tsr_ds,fprint_offset),fprint_length)==0)
      tsr_hit=1;
    else
      tsr_ds+=1;
  }

  if(tsr_hit==1)
     return(tsr_ds);
  else
     return 0;
}

int tsr_install(void)
{
  if (tsr_already_in()) return 1;
  tsr_psp = _psp;    // remember old psp
  disable();
  oldint_tick=getvect(0x08);
  oldint_keyb=getvect(0x09);
  oldint_com2=getvect(0x0b);
  setvect(0x08,newint_tick);
  setvect(0x09,newint_keyb);
  setvect(0x0b,newint_com2);
  enable();
  _dos_keep(0, (_SS + (_SP/16) - _psp));
  return 0;
}

int tsr_uninstall(void)
{
  unsigned tsr_ds=tsr_already_in();
  if (tsr_ds == 0) return (2);

  {
    char far *fp = (char far *)MK_FP(tsr_ds,&tsr_psp);
    tsr_psp = *((unsigned far *)fp);
  }
  { // restore interruptvectors
    disable();
    _fmemcpy(MK_FP(0,0x08*4),MK_FP(tsr_ds,&oldint_tick),4);
    _fmemcpy(MK_FP(0,0x09*4),MK_FP(tsr_ds,&oldint_keyb),4);
    _fmemcpy(MK_FP(0,0x0b*4),MK_FP(tsr_ds,&oldint_com2),4);
    enable();
  }
  { // search for resident memory block
    unsigned cseg,pid,mlen;
    _fmemcpy(MK_FP(_DS,&cseg),MK_FP(0,0xba),2); // INT = 0x2E
    cseg-=1;

    for (;;)
    { // walk through memory chain
      char far *p=(char far *)MK_FP(cseg,0);
      if (*p != 'M') break;
      p++;
      pid=*(unsigned far *)p;
      p++; p++;
      mlen=*(unsigned far *)p;
      cseg+=1;
      if(pid == tsr_psp)
      { // free memory
        union REGS r;
        struct SREGS sr;
        sr.es=cseg;
        r.h.ah=0x49;
        intdosx(&r,&r,&sr);
      }
      cseg+=mlen;
    }
  }
  return (0);
}

void main(int argc,char *argv[])
{
  unsigned char status = inp(PC_PIC+1); // enable COM2-interrupt
  cout << "Aktueller Interruptstatus : " << hex
       << (int)status << endl;
  outp(PC_PIC+1,status&~0x08);

//  outp(PC_COM2+1,3); // Enable TX+RX-Interrupt in 8250
  outp(PC_COM2+1,2); // Enable TX-Interrupt in 8250
  status=inp(PC_COM2+4); // set OUT2
  outp(PC_COM2+4,status|0x08);

  // analyze COM2
  status=inp(PC_COM2+3);
  outp(PC_COM2+3,status|0x80); // setzt DLAB=1
  cout << "DIVISOR: H:" << hex << (int)inp(PC_COM2+1)
               << " L:" << hex << (int)inp(PC_COM2)
               << endl;
  outp(PC_COM2+3,status&~0x80); // setzt DLAB=0
  cout << "IEN: " << hex << (int)inp(PC_COM2+1) << endl;
  cout << "IID: " << hex << (int)inp(PC_COM2+2) << endl;
  cout << "CTL: " << hex << (int)inp(PC_COM2+3) << endl;
  cout << "MOD: " << hex << (int)inp(PC_COM2+4) << endl;
  cout << "LST: " << hex << (int)inp(PC_COM2+5) << endl;
  cout << "MST: " << hex << (int)inp(PC_COM2+6) << endl;


  int return_value;

  switch (argc)
  {
  default:
    cout << "Only arguments /i or /r allowed" << endl;
    return;
  case 2:
    if (!((argv[1][0]=='/')||(argv[1][0]=='-')))
    {
      cout << "Argument starting with '/' or '-'" << endl;
      return;
    }
    if (strlen(argv[1])!=2)
    {
      cout << "Wrong argumentlength" << endl;
      return;
    }
    if ((argv[1][1]=='r') || (argv[1][1]=='R'))
    {
      return_value = tsr_uninstall();
      switch (return_value)
      {
      case 0 :
        cout << __FILE__ << " successfully removed" << endl;
        return;
      case 2 :
        cout << __FILE__ << " not loaded" << endl;
        return;
      case 3:
        cout << "Other programs loaded above " << __FILE__ << endl;
        return;
      }
    }
    else if ((argv[1][1]=='i') || (argv[1][1]=='I'))
    {
      cout << "Installing " << __FILE__ << endl;
      return_value = tsr_install();
      switch (return_value)
      {
      case 1 :
        cout << __FILE__ << "already installed" << endl;
        return;
      }
    }
  }
}

