#include <dos.h>
#include <bios.h>

extern int cdecl _tsr_bypass;
extern int cdecl _tsr_debug;
extern unsigned cdecl TSR_HOTSHIFT;
extern char     cdecl TSR_HOTSCAN;
volatile int cdecl oldpsp;

static struct SREGS segregs;
static union REGS regs;

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif

#if __BORLAND__
  #define getDS() _DS
#endif

/* reduce heaplength and stacklength to make a smaller program in memory */
extern unsigned _heaplen = 1024;
extern unsigned _stklen  = 512;

void interrupt ( *oldint_disk)(__CPPARGS);
void interrupt ( *oldint_tick)(__CPPARGS);
void interrupt ( *oldint_keyb)(__CPPARGS);
void interrupt ( *oldint_v28)(__CPPARGS);

unsigned tsr_dosseg=0;
unsigned tsr_dosoff=0;

void get_dosaddr(void)
{
  union REGS r;
  struct SREGS sr;
  r.x.ax=0x34;
  intdosx(&r,&r,&sr);
  tsr_dosseg=sr.es;
  tsr_dosoff=r.x.bx;
}

void interrupt newint_disk(__CPPARGS)
{
  oldint_disk();
}

void interrupt newint_tick(__CPPARGS)
{
  oldint_tick();
}

int key_pressed=0;
int tsr_reqflag=0;

void interrupt newint_keyb(__CPPARGS)
{
  oldint_keyb();
  if (bioskey(2)==TSR_HOTSHIFT)
  {
    if (TSR_HOTSCAN)
    {
      unsigned Taste;
      Taste=bioskey(1);
      if (Taste)
      {
        key_pressed=1;
        if (((Taste&0xff00)>>8)==TSR_HOTSCAN)
          bioskey(0);
      }
      else
      {
        key_pressed=0;
        return;
      }
    }
    tsr_reqflag=1;
  }
}

void interrupt newint_v28(__CPPARGS)
{
  oldint_v28();
}

int tsr_install(int mode)
{
//  if(tsr_already_in() !=0) return (1);

  switch(mode)
  {
    case 0:_tsr_bypass=0;_tsr_debug=0;break;
    case 1:_tsr_bypass=1;_tsr_debug=0;break;
    case 2:_tsr_bypass=0;_tsr_debug=1;break;
    default:_tsr_bypass=1;_tsr_debug=1;break;
  }

  if (TSR_HOTSCAN>58 && TSR_HOTSCAN<69)
  {
     if(TSR_HOTSHIFT<4) TSR_HOTSCAN+=25;
     else
       if(TSR_HOTSHIFT<8) TSR_HOTSCAN+=35;
       else TSR_HOTSCAN+=45;
  }
  oldpsp=_psp;
  disable();
  oldint_tick=getvect(0x08);
  oldint_keyb=getvect(0x09);
  oldint_disk=getvect(0x13);
  oldint_disk=getvect(0x28);
  setvect(0x08,newint_tick);
  setvect(0x09,newint_keyb);
  setvect(0x13,newint_disk);
  setvect(0x13,newint_v28);
  enable();
  get_dosaddr();
  _dos_keep(0, (_SS + (_SP/16) - _psp));
  return 0;
}

int tsr_already_in(void)
{
  int tsr_hit;
  char near *np, far *fp;
  char tsr_match[20];
  unsigned tsr_seg,tsr_off,tsr_ds;

  tsr_hit=0;
  np=&tsr_fprint[0];
  *np=1;

  fp=MK_FP(getDS(),(unsigned) np);
  tsr_seg=FP_SEG(fp);
  tsr_off=FP_OFF(fp);

  tsr_ds=0x600;
  while((tsr_ds < tsr_seg) && tsr_hit==0)
  {
      peek1(tsr_ds,tsr_off,(void*)&tsr_match,19);
      if(strcmp(tsr_fprint,tsr_match) == 0)
         tsr_hit=1;
      else
	 tsr_ds+=1;
  }

  if(tsr_hit==1)
     return(tsr_ds);
  else
     return 0;
}

int tsr_uninstall(void)
{
  char near *np, far *fp;
  int near *inp,far *ifp;
  unsigned cseg,pid,mlen;
  char mz;
  unsigned tsr_ds,tsr_off;
#if 0
  if (tsr_running==0)
  {
     tsr_ds=tsr_already_in();
     if(tsr_ds == 0) return (2);
  }
  else tsr_ds=getDS();
  tsr_vect_changed=0;
  if (FP_SEG(getvect(0x08))!=tsr_ds) tsr_vect_changed+=1;
  if (FP_SEG(getvect(0x09))!=tsr_ds) tsr_vect_changed+=1;
  if (FP_SEG(getvect(0x13))!=tsr_ds) tsr_vect_changed+=1;
  if (FP_SEG(getvect(0x28))!=tsr_ds) tsr_vect_changed+=1;
  if (tsr_vect_changed!=0) return (3);
  if (tsr_running==0)
  {
     np=&tsr_fprint[0];
     *np=0;
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     poke1(tsr_ds,tsr_off,(void*)&tsr_fprint,1);

     int_off();
     np=(char near *)&old8[0];
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     peek1(tsr_ds,tsr_off,(void*)&old8,4);
     int_on();

     np=(char near *)&old9[0];
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     peek1(tsr_ds,tsr_off,(void*)&old9,4);

     np=(char near *)&old13[0];
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     peek1(tsr_ds,tsr_off,(void*)&old13,4);

     np=(char near *)&old28[0];
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     peek1(tsr_ds,tsr_off,(void*)&old28,4);

     inp=(int near *)&oldpsp;
     ifp=MK_FP(getDS(),(unsigned) inp);
     tsr_off=FP_OFF(ifp);
     peek1(tsr_ds,tsr_off,(void*)&oldpsp,2);
  }
#endif

  disable();
#ifdef __BORLAND__
  setvect(0x08,oldint_tick);
  setvect(0x09,oldint_keyb);
  setvect(0x13,oldint_disk);
  setvect(0x13,oldint_v28);
#endif
#ifdef __ZTC__
  poke1(0x0,32,(void*)&old8,4);
  poke1(0x0,36,(void*)&old9,4);
  poke1(0x0,76,(void*)&old13,4);
  poke1(0x0,160,(void*)&old28,4);
#endif
  enable();

#if 0
  peek1(0,0x00ba,(void*)&cseg,2);
  cseg-=1;
un1:
  peek1(cseg,0,(void*)&mz,1);
  if(mz != 0x4d) goto un9;

  peek1(cseg,1,(void*)&pid,2);
  peek1(cseg,3,(void*)&mlen,2);

  cseg+=1;

  if(pid == oldpsp)
  {
      segregs.es=cseg;
      regs.h.ah=0x49;
      intdosx(&regs,&regs,&segregs);
  }

  cseg+=mlen;
  goto un1;
un9:
  return (0);
#endif
}

int main(void)
{
  tsr_install(3);

  for (;;)
  {
    if (bioskey(1))
    {
      unsigned taste=bioskey(0);
      if (taste==0x011b) break;
    }
  }

  tsr_uninstall()

//  _dos_keep(0, (_SS + (_SP/16) - _psp));
//  return 0;
}


