#undef DEBUG
/*
		   Zortech C and C++ TSR Toolkit
	   (c)1989 Walter Bright, written by Kevin Powis.
		      Version 2.2 AUG 1989
*/
/* modified for BORLANDC Franz Fiala 1992-02-07 */

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include "tsr.h"

#ifdef __ZTC__
#include <int.h>
#include <disp.h>
extern int cdecl _datapar;
extern int cdecl _progpar;
#endif
#ifdef __BORLANDC__
#include "int.h"
#include "disp.h"
int cdecl _datapar=0x20;
int cdecl _progpar=0x1000;
#endif
extern void popmain();
extern char cdecl tsr_fprint[20];

extern int cdecl _tsrdisk;
#ifdef __ZTC__
extern unsigned char cdecl disp_inited;
#endif
extern int cdecl _tsr_bypass;
extern int cdecl _tsr_debug;
extern unsigned cdecl TSR_HOTSHIFT;
extern char     cdecl TSR_HOTSCAN;

volatile int cdecl _tsr_timeslice;
volatile int cdecl tsr_dosseg;
volatile int cdecl tsr_dosoff;
volatile int cdecl tsr_reqflag;
volatile int cdecl tsr_running;
volatile char cdecl old8[4];
volatile char cdecl old9[4];
volatile char cdecl old13[4];
volatile char cdecl old28[4];
volatile int cdecl oldpsp;

int cdecl tsr_vect_changed;
int cdecl tsr_over_graphics;


#ifdef __cplusplus
extern "C" {
#endif

void cdecl tsr_popup(void);
void cdecl tsr_no_pop(void);
void cdecl tsr_dta_on(void);
void cdecl tsr_dta_off(void);
int cdecl tsr_install ( int mode );
int cdecl tsr_uninstall ( void );
void cdecl tsr_test_vect ( unsigned vno , unsigned dataseg );
int cdecl tsr_already_in ( void );
int cdecl tsr_trap28 ( struct INT_DATA* );
int cdecl tsr_newint28 ( struct INT_DATA* );
int cdecl tsr_dosfree ( void );
int cdecl tsr_initialize ( unsigned, unsigned );
#ifdef __cplusplus
}
#endif

#ifdef __BORLANDC__

unsigned getDS(void)
{
  return _DS;
}

void poke1(unsigned seg, unsigned off, void *p, size_t n)
{
  _fmemcpy(MK_FP(seg,off), MK_FP(getDS(),p), n);
}

void peek1(unsigned seg, unsigned off, void *p, size_t n)
{
  _fmemcpy(MK_FP(getDS(),p), MK_FP(seg,off), n);
}

#endif

#ifdef __ZTC__
#define peek1 peek
#define poke1 poke
#endif

unsigned cdecl tsr_codeseg;
struct SREGS segregs;
union REGS regs;

int tsr_install(int mode)
{
  if(tsr_already_in() !=0) return (1);

  switch(mode)
  {
    case 0:_tsr_bypass=0;_tsr_debug=0;break;
    case 1:_tsr_bypass=1;_tsr_debug=0;break;
    case 2:_tsr_bypass=0;_tsr_debug=1;break;
    default:_tsr_bypass=1;_tsr_debug=1;break;
  }

  if (TSR_HOTSCAN>58 && TSR_HOTSCAN<69)
  {
     if(TSR_HOTSHIFT<4) TSR_HOTSCAN+=25;
     else
       if(TSR_HOTSHIFT<8) TSR_HOTSCAN+=35;
       else TSR_HOTSCAN+=45;
  }

  oldpsp=_psp;

  peek1(0x0,32,(void*)&old8,4);
  peek1(0x0,36,(void*)&old9,4);
  peek1(0x0,76,(void*)&old13,4);
  peek1(0x0,160,(void*)&old28,4);
  int_intercept(0x28,tsr_newint28,1500);
  int_intercept(0x28,tsr_trap28,150);
#ifndef DEBUG
  tsr_initialize(tsr_dosseg,tsr_dosoff);
#endif
#if __ZTC
  regs.x.dx=_datapar;
  regs.x.dx=regs.x.dx+_progpar;
  regs.h.ah=0x31;
  intdos(&regs,&regs);
  return 0;
#endif
#if __BORLANDC__
  _dos_keep(0, (_SS + (_SP/16) - _psp));
  return 0;
#endif
}

int tsr_uninstall(void)
{
  char near *np, far *fp;
  int near *inp,far *ifp;
  unsigned cseg,pid,mlen;
  char mz;
  unsigned tsr_ds,tsr_off;

  if (tsr_running==0)
  {
     tsr_ds=tsr_already_in();
     if(tsr_ds == 0) return (2);
  }
  else tsr_ds=getDS();
  tsr_vect_changed=0;
  tsr_test_vect(0x8,tsr_ds);
  tsr_test_vect(0x9,tsr_ds);
  tsr_test_vect(0x13,tsr_ds);
  tsr_test_vect(0x28,tsr_ds);
#ifndef DEBUG
  if (tsr_vect_changed!=0) return (3);
#endif
  if (tsr_running==0)
  {
     np=&tsr_fprint[0];
     *np=0;
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     poke1(tsr_ds,tsr_off,(void*)&tsr_fprint,1);

     int_off();
     np=(char near *)&old8[0];
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     peek1(tsr_ds,tsr_off,(void*)&old8,4);
     int_on();

     np=(char near *)&old9[0];
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     peek1(tsr_ds,tsr_off,(void*)&old9,4);

     np=(char near *)&old13[0];
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     peek1(tsr_ds,tsr_off,(void*)&old13,4);

     np=(char near *)&old28[0];
     fp=MK_FP(getDS(),(unsigned) np);
     tsr_off=FP_OFF(fp);
     peek1(tsr_ds,tsr_off,(void*)&old28,4);

     inp=(int near *)&oldpsp;
     ifp=MK_FP(getDS(),(unsigned) inp);
     tsr_off=FP_OFF(ifp);
     peek1(tsr_ds,tsr_off,(void*)&oldpsp,2);
  }

  int_off();
  poke1(0x0,32,(void*)&old8,4);
  poke1(0x0,36,(void*)&old9,4);
  poke1(0x0,76,(void*)&old13,4);
  poke1(0x0,160,(void*)&old28,4);
  int_on();
  peek1(0,0x00ba,(void*)&cseg,2);
  cseg-=1;
un1:
  peek1(cseg,0,(void*)&mz,1);
  if(mz != 0x4d) goto un9;

  peek1(cseg,1,(void*)&pid,2);
  peek1(cseg,3,(void*)&mlen,2);

  cseg+=1;

  if(pid == oldpsp)
  {
      segregs.es=cseg;
      regs.h.ah=0x49;
      intdosx(&regs,&regs,&segregs);
  }

  cseg+=mlen;
  goto un1;
un9:
  return (0);
}

void tsr_test_vect(unsigned int vno, unsigned int dataseg)
{
  unsigned lseg,loff;

     segread(&segregs);
     tsr_codeseg=dataseg-(segregs.ds-segregs.cs);
     int_getvector(vno,&loff,&lseg);
     if((lseg == tsr_codeseg) || (lseg == dataseg))
	 return;
     else
	 tsr_vect_changed+=1;
}

int tsr_already_in(void)
{
  int tsr_hit;
  char near *np, far *fp;
  char tsr_match[20];
  unsigned tsr_seg,tsr_off,tsr_ds;

     tsr_hit=0;
     np=&tsr_fprint[0];
     *np=1;

     fp=MK_FP(getDS(),(unsigned) np);
     tsr_seg=FP_SEG(fp);
     tsr_off=FP_OFF(fp);

     tsr_ds=0x600;
     while((tsr_ds < tsr_seg) && tsr_hit==0)
     {
	 peek1(tsr_ds,tsr_off,(void*)&tsr_match,19);
	 if(strcmp(tsr_fprint,tsr_match) == 0)
            tsr_hit=1;
         else
	    tsr_ds+=1;
     }

     if(tsr_hit==1)
        return(tsr_ds);
     else
	return 0;
}

int tsr_trap28(struct INT_DATA *p)
{
  return tsr_running;
}

int tsr_newint28(struct INT_DATA *p)
{
int rf;

     if(((tsr_reqflag==0) && (_tsr_bypass==0))  || (tsr_running==1))
	 return 0;

     tsr_running=1;
     rf=tsr_reqflag;

     if(rf!=0)
     {
         _tsr_timeslice=0;
         tsr_reqflag=0;
     }
     else
         _tsr_timeslice=1;

     if(tsr_dosfree() !=0)
     {
        tsr_no_pop();
        tsr_running=0;
	return 0;
     }

     tsr_dta_on();
     popmain();
     tsr_dta_off();

     tsr_running=0;
     return 0;
}

tsr_dosfree()
{
char tsr_busy_flag;
#ifdef __ZTC__
int  disp_state;

     disp_state=disp_inited;
     if(disp_inited==0)
	disp_open();

     tsr_busy_flag=disp_getmode();
     if((tsr_busy_flag > 4) && (tsr_busy_flag !=7) && (tsr_over_graphics==0))
	 return 2;
#endif

     tsr_busy_flag=_tsrdisk;
#ifdef __ZTC__
     if(disp_state==0)
       disp_close();
#endif
     return(tsr_busy_flag);
}

