PAGE   ,132

bios_data_seg  SEGMENT at 0040h
               ORG           0067h
io_rom_init    dw            ?
io_rom_seg     dw            ?
bios_data_seg  ENDS

descriptor     STRUC
seg_limit      dw            0
base_lo_word   dw            0
base_hi_byte   db            0
access_rights  db            0
               dw            0
descriptor     ENDS

cmos_port      equ           070h
code_seg_acc   equ           10011011b
data_seg_acc   equ           10010011b
disable_bit20  equ           11011101b
enable_bit20   equ           11011111b
inta01         equ           021h
intb01         equ           0A1h
port_a          equ           060h
shut_cmd       equ           0FEh
shut_down      equ           00Fh
status_port    equ           064h
virtual_enable equ           0001h


lgdt           MACRO         lgdt1
               LOCAL         lgdt2,lgdt3
               db            00Fh

lgdt2          label         byte
               mov           dx,word ptr lgdt1
lgdt3          label         byte
               org           offset lgdt2
               db            001h
               org           offset lgdt3
               ENDM

lmsw           MACRO         lmsw1
               LOCAL         lmsw2,lmsw3
               db            00Fh

lmsw2          label         byte
               mov           si,ax
lmsw3          label         byte
               org           offset lmsw2
               db            001h
               org           offset lmsw3
               ENDM

jumpfar        MACRO         jumpfar1,jumpfar2
               db            0EAh
               dw            (offset jumpfar1)
               dw            jumpfar2
               ENDM


cseg           SEGMENT       para public 'code'
               ASSUME        cs:cseg
               ORG           100h
start:         jmp           short main
EVEN
gdt            LABEL         word
gdt_desc       EQU           (($-gdt)/8)*8
gdt1           descriptor    <gdt_leng,,,data_seg_acc,>
cs_code        EQU           (($-gdt)/8)*8
gdt2           descriptor    <cseg_leng,,,code_seg_acc,>
cs_data        EQU           (($-gdt)/8)*8
gdt3           descriptor    <cseg_leng,,,data_seg_acc,>
ss_desc        EQU           (($-gdt)/8)*8
gdt4           descriptor    <0FFFFh,,,data_seg_acc,>
ds_desc        EQU           (($-gdt)/8)*8
gdt5           descriptor    <0FFFFh,,,data_seg_acc,>
es_desc        EQU           (($-gdt)/8)*8
gdt6           descriptor    <0FFFFh,,,data_seg_acc,>
gdt_leng       EQU           $-gdt
PAGE

i8259_1        db            ?
i8259_2        db            ?

               ASSUME        ds:cseg
main           PROC
               cld
               mov           dx,cs
               mov           cx,offset gdt
               call          form_24bit_address
               mov           gdt1.base_lo_word,dx
               mov           gdt1.base_hi_byte,cl
               mov           dx,cs
               xor           cx,cx
               call          form_24bit_address
               mov           gdt2.base_lo_word,dx
               mov           gdt2.base_hi_byte,cl
               mov           gdt3.base_lo_word,dx
               mov           gdt3.base_hi_byte,cl
               mov           dx,ss
               xor           cx,cx
               call          form_24bit_address
               mov           gdt4.base_lo_word,dx
               mov           gdt4.base_hi_byte,cl
               lgdt          gdt
               mov           ah,enable_bit20
               call          gate_a20
               or            al,al
               jz            m_10
               mov           dx,offset gate_failure
               mov           ah,9
               int           21h
               int           20h

gate_failure   db            "Address A20 failed to Gate open$"

m_10:          cli
               in            al,inta01
               mov           i8259_1,al
               in            al,intb01
               mov           i8259_2,al

               ASSUME        ds:bios_data_seg
               mov           dx,bios_data_seg
               mov           ds,dx
               mov           io_rom_seg,cs
               mov           io_rom_init,offset real
               mov           al,shut_down
               out           cmos_port,al
               jmp           short $+2
               mov           al,5h
               out           cmos_port+1,al
               mov           ax,virtual_enable
               lmsw          ax
               jumpfar       m_20,cs_code

m_20:          ASSUME        ds:cseg
               mov           ax,ss_desc
               mov           ss,ax
               mov           ax,cs_data
               mov           ds,ax
               mov           gdt5.base_lo_word,8000h
               mov           gdt5.base_hi_byte,0Bh
               mov           gdt6.base_lo_word,8000h
               mov           gdt6.base_hi_byte,0Bh
               mov           ax,ds_desc
               mov           ds,ax
               mov           ax,es_desc
               mov           es,ax
               mov           cx,80*25
               xor           si,si
               xor           di,di

m_30:          lodsw
               mov           ah,70h
               stosw
               loop          m_30
               mov           al,shut_cmd
               out           status_port,al

m_40:          hlt
               jmp           short m_40


gate_a20       PROC
               cli
               call          empty_8042
               jnz           gate_a20_01
               mov           al,0D1h
               out           status_port,al
               call          empty_8042
               jnz           gate_a20_01
               mov           al,ah
               out           port_a,al
               call          empty_8042
gate_a20_01:   ret
gate_a20       ENDP

empty_8042     PROC
               push          cx
               sub           cx,cx
empty_8042_01: in            al,status_port
               and           al,00000010b
               loopnz        empty_8042_01
               pop           cx
               ret
empty_8042     ENDP

form_24bit_address PROC
               push          ax
               rol           dx,1
               rol           dx,1
               rol           dx,1
               rol           dx,1
               mov           ax,dx
               and           dl,0F0h
               and           ax,0Fh
               add           dx,cx
               mov           cx,ax
               adc           cl,ch
               pop           ax
               ret
form_24bit_address ENDP

               ASSUME        ds:cseg
real:          mov           dx,cs
               mov           ds,dx
               mov           ah,disable_bit20
               call          gate_a20
               mov           al,i8259_1
               out           inta01,al
               mov           al,i8259_2
               out           intb01,al
               sti
               int           20h
main           ENDP
cseg_leng      EQU           $
cseg           ENDS
               END           start
               END.




