; RamAd.Sys - Treiber

PushA    Macro
         Push      AX
         Push      CX
         Push      DX
         Push      BX
         Push      SI
         Push      DI
         EndM

PopA     Macro
         Pop       DI
         Pop       SI
         Pop       BX
         Pop       DX
         Pop       CX
         Pop       AX
         EndM

Header   Struc
Lenge    DB        ?         ; 0
Unit     DB        ?         ; 1
Cmd      DB        ?         ; 2
Stat     DW        ?         ; 3-4
Reserve  DB        8 dup (?) ; 5-12
Media    DB        ?         ; 13
Adress   DD        ?         ; 14-17
Count    DW        ?         ; 18-19
Sector   DW        ?         ; 20-21
Header   Ends

ROM_386  Equ       1         ; Freischaltung C000-CFFF,F000-FFFF

Rom_Neat Equ       0         ; 1 bei 286-NEAT

Dos_400  Equ       1         ;

Treiber  Segment   Byte
         Assume    CS:Treiber
         Org       0

NextDev  DD        -1
Attrib   DW        1000000000000000B
Strat    DW        Strategy
Inter    DW        Interr
DevName  DB        'RAMAD   '

Request  DD        ?
StrtSkip DW        0B000H    ; Vorbelegungen, die
EndSkip  DW        0C000H    ; eventuell bei der
MaxSeg   DW        0F000H    ; Installation umbelegt werden
No_Adj   DB        0         ; Flag zum Verschieben

;----------------------------------------------------------------

Strategy Proc      Far

         Mov       CS:Word Ptr [Request],BX
         Mov       CS:Word Ptr [Request+2],ES
         Ret

Strategy EndP

;---------------------------------------------------------------

Srch_Bl: Cmp       Byte Ptr [SI],20H
         Jz        Bl_Fnd              ; Sucht in der
         Inc       SI                  ; Eingabezeile
         Jmp       Short Srch_Bl       ; nach Leerzeichen
Bl_Fnd:  Cmp       Byte Ptr[SI],20H
         Jnz       No_Bl
         Inc       SI
         Jmp       Short Bl_Fnd
No_Bl:   Ret

ConvHex: Mov       DX,0
         Mov       CX,4
Loop2:   Mov       AL,[SI]
         Call      To_Bin
         Inc       SI
         Mov       AH,0
         Shl       DX,1
         Shl       DX,1
         Shl       DX,1
         Shl       DX,1
         Add       DX,AX
         Loop      Loop2
         Mov       AX,DX
         Ret

To_Bin:  Sub       AL,'0'
         Cmp       AL,9
         Jle       No_Sub
         Sub       AL,7
No_Sub:  Ret

Ausgabe: Mov       AL,CS:[SI]         ; einfache Zeichenausgabe
         Or        AL,AL
         Jz        Ende
         Mov       AH,0EH
         Mov       BX,7
         Int       10H
         Inc       SI
         Jmp       Short Ausgabe
Ende:    Ret

Out_Hex: Mov       CX,4
         Push      AX
Loop3:   Pop       AX
         Rol       AX,1
         Rol       AX,1
         Rol       AX,1
         Rol       AX,1
         Push      AX
         And       AL,0FH
         Add       AL,'0'
         Cmp       AL,'9'
         Jle       No_Add
         Add       AL,7
No_Add:  Mov       AH,0EH
         Mov       BX,7
         Int       10H
         Loop      Loop3
         Pop       AX
         Mov       SI,Offset CrLf
         Call      Ausgabe
         Ret

Hol_Par: Push      DS
         Mov       AX,ES:[BX].Count
         Mov       SI,AX
         Mov       AX,ES:[BX].Count+2
         Mov       DS,AX
Loop1:   Cmp       Byte Ptr [SI],20H
         Jnz       Name_F
         Inc       SI
         Jmp       Short Loop1
Name_F:  Call      Srch_Bl
         Call      ConvHex
         Mov       CS:Maxseg,AX
         Call      Srch_Bl
         Call      ConvHex
         Mov       CS:StrtSkip,AX
         Call      Srch_Bl
         Call      ConvHex
         Mov       CS:EndSkip,AX
         Pop       DS
         Ret

; Parameter anzeigen:

Sho_Par: Push      BX
         Mov       SI,Offset StrtMsg
         Call      Ausgabe
         Mov       SI,Offset Para1
         Call      Ausgabe
         Mov       AX,CS:MaxSeg
         Call      Out_Hex
         Mov       SI,Offset Para2
         Call      Ausgabe
         Mov       AX,CS:StrtSkip
         Call      Out_Hex
         Mov       SI,Offset Para3
         Call      Ausgabe
         Mov       AX,CS:EndSkip
         Call      Out_Hex
         Pop       BX
         Ret

Interr   Proc     Far
         PushA
         LES       BX,CS:DWord Ptr [Request]
         Mov       AL,ES:[BX].Cmd
         Or        AL,AL
         Jz        Init_Tr
         Cmp       AL,8
         Jz        De_Inst
         Cmp       AL,9
         Jz        De_Inst
         Mov       AH,0
         Jmp       Short Exit
Er_Exit: Mov       AH,80H
Exit:    Or        AH,1
         Mov       ES:[BX].Stat,AX
         PopA
         Ret

De_Inst: Jmp       DInstall

Init_Tr:

If       Rom_386 Or Rom_Neat

         If        Rom_386
         Mov       AL,9
         EndIf

         If        Rom_Neat
         Mov       AL,65H
         EndIf

         Out       22H,AL
         Jmp       Short $+2
         In        AL,23H
         And       AL,6FH
         Push      AX

         If        Rom_386
         Mov       AL,9
         EndIf

         If        Rom_Neat
         Mov       AL,65H
         EndIf

         Out       22H,AL
         Jmp       Short $+2
         Pop       AX
         Out       23H,AL

EndIf

         Call      Hol_Par             ; Eingabezeile
         Push      ES
         Mov       AX,40H
         Mov       ES,AX
         Mov       AX,CS:MaxSeg        ; Fuer Vergleich
         Mov       CX,6
         Shr       AX,CL
         Cmp       ES:[13H],AX
         Jz        Zw_Boot

         Mov       ES:[13H],AX         ; neue Speichergroesse
         Mov       ES:Word Ptr [72H],1234H ; Reset
         Pop       ES
         Int       19H                 ; Warm Boot

Zw_Boot: Pop       ES
         Call      Sho_Par
         Mov       Word Ptr ES:[BX].Adress,0
         Mov       AX,CS:EndSkip       ; Endadresse des Treibers
         Inc       AX
         Mov       Word Ptr ES:[BX].Adress+2,AX
         Xor       AX,AX
         Jmp       Exit

DInstall:Cli
         Mov       SI,Offset De_Ins
         Call      Ausgabe
         Cmp       CS:Word Ptr [Nextdev+2],70H
         Jz        Erster
         Jmp       N_Erst              ; Kette verfolgen

Erster:  Push      ES

; 1. Eigenes Segment -1 als leer markieren
;    mit der Laenge StrtSkip-1 eigenes Segment

         Mov       AX,CS               ; hole eigenes Segm.
         Mov       BX,CS:StrtSkip      ; bis wohin frei

If       DOS_400
         Dec       BX
Else                                   ; 16 Bytes fuer MCB
;         Dex       BX
EndIf

         Push      AX
         Sub       BX,AX
         Pop       AX
         Dec       AX

If       DOS_400
         Dec       AX
EndIf
         Mov       ES,AX               ; im MCB sichern
         Mov       Word Ptr ES:[1],0   ; freies Segment
         Mov       AX, Word Ptr ES:[3] ; alten Wert sichern
         Mov       CX,AX
         Mov       Word Ptr ES:[3],BX  ; richtige Laenge

; 2. bei StrtSkip-1 ein Segment auf StrtSkip mit Laenge
;    EndSkip-StrtSkip aufbauen.

Weiter:  Mov       AX,CS:StrtSkip      ; Differenz berechnen

If       DOS_400
         Dec       AX
         Mov       ES,AX               ; damit Mem.EXE die
         Mov       ES:Byte Ptr [0],0   ; Untereinheiten
         Mov       ES:Word Ptr [1],0   ; korrekt erkennt
         Mov       ES:Word Ptr [3],0
EndIf

         Push      AX
         Dec       AX
         Mov       ES,AX
         Pop       AX
         Mov       Byte Ptr ES:[0],'M' ; neuen MCB/Block bei
         Mov       Word Ptr ES:[1],AX  ; StrtSkip-1
         Mov       ES:Word Ptr [8],'uL'
         Mov       ES:Word Ptr [10],'ce' ; Pseudo Name
         Mov       ES:Word Ptr [12],'ek' ; fuer Skip-
         Mov       ES:Word Ptr [14],'!!' ; Speicherbereich
         Mov       BX,CS:EndSkip
         Sub       BX,AX
         Mov       Word Ptr ES:[3],BX  ; Video-Speicher

; 3. Bei EndSkip ein Segment auf EndSkip+1 mit der Laenge
;    (altes RAMAD-Seg.  +  Start eigenes Segm. - Endskip+1)
;    einrichten.

         Mov       AX,CS:EndSkip
         Push      AX
         Mov       ES,AX
         Mov       AX,CS

If       DOS_400
         Dec       AX
EndIf

N_Erst2: Add       AX,CX               ; Berechnung w. o.
         Pop       CX
         Inc       CX
         Sub       AX,CX               ; Gesamtwert
         Mov       Byte Ptr ES:[0],'M'
         Mov       Word Ptr ES:[1],8
         Mov       Word Ptr ES:[3],AX
         Cmp       CS:[No_Adj],1       ; Kette d. Treiber
         Jz        No_Kett             ; neu einrichten

; 4. DWord-Pointer bei EndSkip+1 auf eigenen Pointer-Wert

         Mov       AX,CS:[EndSkip]
         Inc       AX

If       DOS_400
         Inc       AX
EndIf

         ; Kette d. naechsten Treibers auf vorigen einstellen

         Mov       ES,AX
         Mov       AX,Word Ptr CS:[NextDev]
         Cmp       Word Ptr ES:[0],0FFFFH
         Jz        No_Kett
         Mov       Word Ptr ES:[0],AX
         Mov       AX,Word Ptr CS:[NextDev+2]
         Mov       Word Ptr ES:[2],AX

No_Kett: Pop       ES                  ; sonst einfach weg
         Xor       AX,AX
         Sti
         Jmp       Exit

N_Erst:

; Kette nach vorne verfolgen, bis ein Eintrag mit 70:xxxx
; gefunden wird. Davor liegt der MCB fuer alle Treiber u. Buffer

         Push      ES
         Mov       CS:[No_Adj],1
         Mov       AX,CS
         Mov       ES,AX
         Mov       BX,0
Loops:   Mov       AX,ES:[BX+2]
         Mov       BX,ES:[BX]
         Cmp       AX,70H              ; letzter Treiber ?
         Jz        L_Found
         Mov       ES,AX
         Jmp       Short Loops
L_Found: Mov       AX,ES

; MCB aendern, sodass alles vor RAMAD als belgt erkennbar

         Dec       AX
If       DOS_400
         Dec       AX
EndIf
         Mov       ES,AX
         Inc       AX
         Mov       ES:Word Ptr [1],8   ; ist belegt
         Mov       CX,ES:[3]           ; fuer spaeter
         Mov       BX,CS

If       DOS_400
         Dec       BX
EndIf

         Sub       BX,AX
         Sub       CX,BX               ; fuer spaeter
         Mov       ES:[3],BX           ; Laenge d. 1. Blocks
         Mov       AX,CS:[EndSkip]
         Inc       AX

If       Dos_400
         Inc       AX
EndIF

         Mov       ES,AX
         Cmp       ES:[0],0FFFFH        ; Treiberkette
         Jz        No_More              ; umbauen
         Mov       AX,CS:Word Ptr [NextDev]
         Mov       ES:[0],AX
         Mov       AX,CS:Word Ptr [NextDev+2]
         Mov       ES:[2],AX
No_More:

; MCB bei RAMAD installieren, der freien Bereich bis
; StrtSkip angibt.

         Mov       AX,CS

If       DOS_400
         Dec       AX
EndIf

         Mov       ES,AX
         Mov       ES:Byte Ptr[0],'M'
         Mov       ES:Word Ptr[1],0    ; Speicher
         Mov       BX,CS:[StrtSkip]    ; freischalten
         Dec       BX

If       DOS_400
         Dec       BX
EndIF

         Sub       BX,AX
         Dec       BX
         Mov       ES:[3],BX           ; soviel sind frei
         Jmp       Weiter

Interr   EndP

StrtMsg  DB        0AH,0DH,'RAMAD-Treiber V 1.2 '
         DB        0AH,0DH,00H

Para1    DB        'End-Segment        : ',00H
Para2    DB        'Start-Skip-Segment : ',00H
Para3    DB        'End-Skip-Segment   : ',00H
De_Ins   DB        'RAMAD abgeschaltet   ',0DH,0AH,0H
CRLF     DB        0AH,0DH,00

Treiber  Ends

End







