
/********************************************************************/
/*				Test the cheak_heap class.							 */
/********************************************************************/

#include <iostream.h>

#include <heap.hpp>

struct test_class_bad		// Class that does not deallocate.
{
	CHAR *p;
	test_class_bad()	{ p = new char; }
	~test_class_bad()	{ /* p is not deleted. */ }
private:
	test_class_bad(test_class_bad&);
};

struct test_class_good		// Class that does deallocate.
{
	CHAR *p;
	test_class_good() { p = new char; }
	test_class_good(test_class_good &t) { p = new char; *p = *(t.p); }
	~test_class_good()	{ delete p; }
};

CHAR *test_easy(const int);		// Prototypes for test functions.
CHAR *test_class(const int);
VOID test_value(test_class_good);
VOID test_test_value(test_class_good &t)	{ test_value(t); }


main()
{
	test_class_good t;
    CHAR *p;

	cout << "Testing check_heap class.  Should have three okay errors\n";
	check_heap check;

	p = test_easy(1);
	check.test("Test_easy(1) error: ");

	p = test_easy(0);
	check.test("This error is okay: ");
    delete p;	// Clean up memory and fix for next check.test().

	p = test_class(1);
	check.test("Test_class(1) error: ");

	p = test_class(0);
	check.test("This error is okay: ");
	delete p;		// Clean up memory.

	check.start();	// Get ready for next call to check.test().

	// Next line demonstrates compiler creating temp value.
	test_value(t);
	check.testnew("This error is okay: ");
	test_test_value(t);
	check.test("Test_test_value(t) error: ");
}

CHAR *test_class(const INT i)
{
	CHAR *r;

	if (i)
		{
		test_class_good t;
        r = 0;
		}
	else{
		test_class_bad t;
        r = t.p;
		}
	return r;
}
	
CHAR *test_easy(const INT i)
{
	CHAR *p = new char;
	if (i)	{ delete p;  p = 0; }
    return p;
}

VOID test_value(test_class_good t)
{	/* Ignore warning about t not being used. */ }
