
#include <mytypes.h>
#include <iostream.h>

#define comp(c,i)	( ((c) == int(i)) ? "okay.\n" : "not okay.\n")

VOID test_init(INT c)  { cout << "   Initialization is " << comp(c,3);}
VOID test_inc(INT c)   { cout << "   Increment is " << comp(c,4); }
VOID test_dec(INT c)   { cout << "   Decrement is " << comp(c,3); }
VOID test_eql(INT c)   { cout << "   Equal for INT is " << comp(c,3);}

CHAR *test(INT i)		{ return i ? "okay.\n" : "not okay.\n"; }

VOID main(VOID)
{

/********************************************************************/
/*				Test the boolean class.								 */
/********************************************************************/
#ifdef BASIC_TYPES
	BOOLc b1,b2;
#else
	BOOLc b1=FALSE, b2=FALSE;
#endif
	cout << "Testing boolean class\n";
	cout << "Constructed value and int() is " << test(b1 == FALSE);
	cout << "Comparison is " << test(b1 == b2);
#ifdef BASIC_CLASSES
	b1 = 1;
#else
	b1 = TRUE;
#endif
	cout << "Operator=() is " << test(b1 == true);

#ifdef BASIC_CLASSES
	b1 = ~b2;
#else
	b1 = (b2==TRUE)?FALSE:TRUE;
#endif
	cout << "Operator~() is " << test(b1 == true);
#ifdef BASIC_CLASSES
	b1++;
#else
	b1 = (b1==TRUE)?FALSE:TRUE;
#endif
	cout << "Operator++() is " << test(b1 == false);
#ifdef BASIC_CLASSES
	b1--;
#else
	b1 = (b1==TRUE)?FALSE:TRUE;
#endif
	cout << "Operator--() is " << test(b1 == true);
#ifdef BASIC_CLASSES
	cout << "Make_string() is " << b1 << "ly okay.\n";
	true = false;	// This only produces warning message.
#else
	cout << "Make_string() is ";
	if (b1==TRUE)
	  cout << "true";
	else
	  cout << "false";
	cout << "ly okay.\n";
#endif

/********************************************************************/
/*		Test byte and word classes.  Copyright Joe Schell 1989.      */
/********************************************************************/

	cout << "Testing UCHARc and UINTc class.\n";

	UCHARc b, c=3, *d;
	CHAR *test_byte = "abc";
	cout << "UCHARc:( should be 03, result=" << c << ")\n";
	test_init(c);
	c++;	test_inc(c);
	c--;	test_dec(c);
	b=c;	test_eql(b);
	c=4;
	cout << "   Setting equal to integer is " << comp(c,4);

    b=c;
    c++;
	cout << "   Comparison of UCHARs is "
		 << ((b!=c) ? "okay." : "not okay.") << "\n";
	d = (UCHARc*)test_byte;
	cout << "   Pointing is " << comp(*d,*test_byte);
	d++;
	cout << "   Incrementing pointer is " << comp(*d,*(test_byte+1));

	UINTc x, y=3, *z;
	INT test_word=8;
	cout << "\nUINT:( should be 0003, result=" << y << ")\n";
	test_init(y);
	y++;	test_inc(y);
	y--;	test_dec(y);
	x=y;	test_eql(x);
	y++;
	cout << "   Comparison of UINTs is "
		<< ((x!=y) ? "okay." : "not okay.") << "\n";
	z = (UINTc*)(&test_word);
	cout << "   Pointer to UINTc is " << comp(*z,test_word);
	(*z)++;
	cout << "   Dereference and increment is " << comp(*z,9);

	// The next two lines should cause 'Illegal values' when
    // not commented.
	// b=UCHAR_MAX + 1;
	// x=(LONG)UINT_MAX + 1;

	cout << "\nTest is finished.\n";
}

