/* HC04CM1.C */
/* 
 * Schreiben und Lesen des CMOS-RAM
 * ================================
 */
#include <portable.h>
#include <constream.h>
#include <iodef.h>
#include <mytypes.h>

UCHAR CMOSRAM_read(UINT adr);
VOID CMOSRAM_write(UINT adr, UCHAR value);
UINT CMOSRAM_chksum(VOID);
VOID CMOSRAM_printf(constream& con);

VOID main(VOID)
{
  INT adr, checksum, value;
  constream con;
  con.clrscr();

  for (;;)
  {
    CMOSRAM_printf(con);
    checksum=CMOSRAM_chksum();
    con << setxy(1,18);
    con << "Checksum of adr 0x10..0x2d:";
    con << setw(4) << hex << checksum;
    do /* Read address to change */
    {
      con << setxy(1,19) << clreol;
      con << "Alter byte (adr=0 ends) adr: ";
      cin >> hex >> adr;
      if (adr==0) return;
    }
    while ((adr<0x10) || (adr>0x7f));
    con << clreol;
    con << "value: ";
    cin >> hex >> value;
    CMOSRAM_write(adr,value);
    // Update CHECKSUM if necessary
    checksum=CMOSRAM_chksum(); 
    con << clreol;
    if (checksum != CMOSRAM_read(0x2e)*256
                   +CMOSRAM_read(0x2f))
    {
      CMOSRAM_write(0x2e,checksum/256);
      CMOSRAM_write(0x2f,
                    checksum-256*(checksum/256));
      con << "CHECKSUM updated";
    }
    else
      con << "CHECKSUM ok";
  }
}

UCHAR CMOSRAM_read(UINT adr)
{
  OUT_PORT(AT_CMOS_ADR,adr);
  return IN_PORT(AT_CMOS_DAT);
}

VOID CMOSRAM_write(UINT adr, UCHAR value)
{
  OUT_PORT(AT_CMOS_ADR,adr);
  OUT_PORT(AT_CMOS_DAT,value);
}

UINT CMOSRAM_chksum(VOID)
{
  UINT checksum=0;
  for (INT adr=0x10; adr<=0x2d; adr++ )
    checksum+=CMOSRAM_read(adr);
  return checksum;
}

VOID CMOSRAM_printf(constream& con)
{
  const INT COL=8;
  const INT LIN=16;

  con.clrscr();
  con << "Contents of CMOS-RAM" << endl;
  for (INT adr=0; adr<=0x7f; adr++)
  {
    con << setxy(1+COL*(adr/LIN),adr-(adr/LIN)*LIN+2);
    con << hex << setw(2) << setfill('0')
	<< adr;
    con << ":";
    con << hex << setw(2) << setfill('0')
	<< (INT)CMOSRAM_read(adr);
  }
}
