/* HC04IO2.CPP */
/* 
 * Anzeige und nderung des Zustandes von IO-Ports
 * ===============================================
 */
#include <string.h>
#include <stdlib.h>
#include <mylib.h>
#include <portable.h>
#include <iodef.h>
#include <keyscan.h>
#include <io.hpp>
#ifndef MYLIB
#include "\mylib\source\io.cpp"
#endif

const INT MAXPORT=255;

INT main(INT argc, CHAR * argv[])
{
  IOBYTE_IO *port[MAXPORT];

  if (argc==1) // Hilfe-Anzeigen
  {
    cout << "\nAnzeige und nderung von IO-Ports\n";
    cout <<   "=================================\n";
    cout << "Aufruf: " << __FILE__
	 << "{adr|adr" << TRENN_OUT << "hh|adr"
	 << TRENN_IO << "hh} " << endl;
    cout << "adr    ... drei HEX-Stellen \n";
    cout << "hh     ... zwei HEX-Stellen \n";
    cout << "adr    ... IN: zeigt Portwert adr an " ;
    cout << DISP_IN << endl;
    cout << "adr" << TRENN_OUT
	 << "hh ... OUT: ndert Portwert adr auf hh "
	 << DISP_OUT << endl;
    cout << "adr" << TRENN_IO
	 << "hh ... IN_OUT: ndert Portwert adr auf hh"
	    "und zeigt Portwert an "
	 << DISP_IO << endl;
    return EXIT_FAILURE;
  }
  for (INT i=1; i<argc; i++)
  {
    INT adr_t;
    DIRECTION io_t;
    UCHAR val_t;

    if (chk(argv[i],adr_t,io_t,val_t,TRUE)==IO_NOERROR)
    {
      port[i-1] = new IOBYTE_IO(adr_t,val_t);
      port[i]=NULL;
      continue;
    }
    else
      exit(EXIT_FAILURE);
  }

  { // testing multiple assignments
    // ============================

    BOOL exist[PC_MAXPORTS][2];

    for (INT i=0; i<PC_MAXPORTS; i++)
      for (INT j=0; j<2; j++)
	exist[i][j]=FALSE;

    IOBYTE_IO **iop=port;
    while (*iop)
    {
      INT adr=(*iop)->adr();
      DIRECTION io=(*iop)->io();
      if (exist[adr][io])
      {
	cout << "\nDoppelbelegung bei: "
	     << hex << (*iop)->adr();
	return EXIT_FAILURE;
      }
      else
	exist[(*iop)->adr()][(*iop)->io()]=TRUE;
      iop++;
    }
  }

  constream con;
  con.clrscr();
  BOOL start=TRUE;

  for (;;)
  {
    INT displayposition=0;
    IOBYTE_IO **iop=port;

    while (*iop)
    {
      if (kbhit())
      {
	UINT c = getch();
	if (c==0x1b) return EXIT_SUCCESS;
      }

      UCHAR old_value = (**iop).old();

      // Bildschirm nur bei nderungen
      // und zu Beginn auffrischen
      if ((old_value!=(**iop)()) || (start))
      {
	INT  char_position, row, column;
	char_position=displayposition*8;
	column = char_position % 80;
	row = char_position / 80;
	con << setxy(column+1,row+1) << (**iop);
      }
      iop++;
      displayposition++;
    }
    start = FALSE;
  }
}
