/* HC04SE1.CPP */
/*
 * Testen der seriellen Schnittstelle
 * ==================================
 */
#include <iodef.h>
#include <portable.h>
#include <mytypes.h>
#include <io.hpp>
#ifndef MYLIB
#include "\mylib\source\io.cpp"
#endif

const INT NUMPORTS=4;

UINT ports[NUMPORTS] =
  { PC_COM1, PC_COM2, PC_COM3, PC_COM4 };
BOOL exist[NUMPORTS] =
  { FALSE,   FALSE,   FALSE,   FALSE };

INT error=0;

VOID main(INT argc)
{
  cout << endl;
  cout << "SERIAL-PORTTEST\n";
  cout << "===============\n";

  if (argc>1)
  {
    cout << endl;
    cout << "PORT-Adressen: ";
    for (INT i=0; i<NUMPORTS; i++)
    {
      cout << hex << ports[i] << ", ";
    }
    cout << endl;
    cout <<"PORT+0 3F8 (DLAB=1) Baudrate low Byte\n";
    cout <<"PORT+1 3F9 (DLAB=1) Baudrate high Byte\n";
    cout <<"            PORT+1           PORT+0     \n";
    cout <<"        f e d c b a 9 8  7 6 5 4 3 2 1 0\n";
    cout <<"        0 0 0 0 1 0 0 1  0 0 0 0 0 0 0 0    50\n";
    cout <<"        0 0 0 0 0 0 0 1  1 0 0 0 0 0 0 0   300\n";
    cout <<"        0 0 0 0 0 0 0 0  0 1 1 0 0 0 0 0  1200\n";
    cout <<"        0 0 0 0 0 0 0 0  0 0 1 1 0 0 0 0  2400\n";
    cout <<"        0 0 0 0 0 0 0 0  0 0 0 1 1 0 0 0  4800\n";
    cout <<"        0 0 0 0 0 0 0 0  0 0 0 0 1 1 0 0  9600\n";
    cout <<"        0 0 0 0 0 0 0 0  0 0 0 0 0 1 1 0 19200\n";
    cout <<"        0 0 0 0 0 0 0 0  0 0 0 0 0 0 1 1 38400\n";
    cout <<"        0 0 0 0 0 0 0 0  0 0 0 0 0 0 1 0 56000\n";
    cout <<"PORT+0 3F8 (DLAB=0) DATEN-RX/TX\n";
    cout <<"PORT+1 3F9 (DLAB=0) INTERRUPT-Enable\n";
    cout <<"        7     6     5     4     3     2     1     0\n";
    cout <<"        0     0     0     0     CTS   OR    TX    RX\n";
    cout <<"                                DTR   PE \n";
    cout <<"                                RI    FE \n";
    cout <<"                                DCD   BI \n";
    cout <<"              Prioritt:        1     2     3     4\n";
    cout <<"Weiter mit Taste";cin.get();
    cout <<"PORT+2 3fA INTERRUPT-Status\n";
    cout <<"        7     6     5     4     3     2     1     0\n";
    cout <<"        0     0     0     0     0     x     x     1 NO INT\n";
    cout <<"                                      1     1     0 RX-Line\n";
    cout <<"                                      1     0     0 RX-Data\n";
    cout <<"                                      0     1     0 TX-Data\n";
    cout <<"                                      0     0     0 Modemstatus\n";
    cout <<"PORT+3 3FB LINE-Control\n";
    cout <<"        7     6     5     4     3     2     1     0\n";
    cout <<"                    <--PARITY----->   STOPB DATABITS\n";
    cout <<"        DLAB        SP    0 ODD       0->1  0     0  5 Bits\n";
    cout <<"              1=TXOFF     1 EVEN      1->2  1     0  6 Bits\n";
    cout <<"              0=TXON            0 NO        0     1  7 Bits\n";
    cout <<"                                1 YES       1     1  8 Bits\n";
    cout <<"Weiter mit Taste";cin.get();
    cout <<"PORT+4 3FC MODEM-Control\n";
    cout <<"        7     6     5     4     3     2     1     0\n";
    cout <<"        0     0     0     LOOP  OUT2  OUT1  RTS   DTR\n";
    cout <<"PORT+5 3FD LINE-Status\n";
    cout <<"        7     6     5     4     3     2     1     0\n";
    cout <<"        0     TS    TX    BI    FE    PE    OR    RX\n";
    cout <<"PORT+6 3FE Modem-Status\n";
    cout <<"        7     6     5     4     3     2     1     0\n";
    cout <<"        DCD   RI    DSR   CTS   DDCD  DRI   DDSR  DCTS\n";
    cout <<"Weiter mit Taste";cin.get();
    cout <<"Pinbelegung\n";
    cout <<"        TX    RX    DTR   DSR   RTS   CTS   DCD   RI   GND\n";
    cout <<"24-pol: 2     3     20    6     4     5     8     22   1,7\n";
    cout <<" 9-pol: 3     2     4     6     7     8     1     9    5\n";
    cout <<"Serieller Testadapter verbindet: \n";
    cout <<"24-pol: 1-7, 2-3, 4-5-8, 6-20, 11-22, 15-17-23, 18-25\n";
    cout <<" 9-pol:      2-3, 1-7-8, 4-6                         \n";
    cout <<"Weiter mit Taste";cin.get();
    exit(EXIT_FAILURE);
  }

  for (INT port=0; port<NUMPORTS; port++)
  {
    INT error=0;

#undef DIAG

    // Test if DTR and RTS can be read back
    IOBIT_IO dtr(0,ports[port]+4);
    IOBIT_IO rts(1,ports[port]+4);

    dtr = 1;
    if (dtr()!=1)
    {
      error++;
#ifdef DIAG
      cout << "DTR=1:" << dtr << endl;
#endif
    }
    dtr = 0;
    if (dtr()!=0)
    {
      error++;
#ifdef DIAG
      cout << "DTR=0:" << dtr << endl;
#endif
    }

    rts = 1;
    if (rts()!=1)
    {
      error++;
#ifdef DIAG
      cout << "RTS=1:" << rts << endl;
#endif
    }
    rts = 0;
    if (rts()!=0)
    {
      error++;
#ifdef DIAG
      cout << "RTS=0:" << rts << endl;
#endif
    }

    cout << "Port-Nr: " << port
	 << "/" << hex << ports[port];

    if (error)
    {
      exist[port]=FALSE;
      cout << " not";
    }
    else
    {
      exist[port]=TRUE;
    }
    cout << " available" << endl;
  }

  for (port=0; port<NUMPORTS; port++)
  {
    if (exist[port]==FALSE) continue;

    cout << "Insert Test-Plug in port " << port
	 << " and press a key!";
    cin.get();

    IOBYTE_IO data(ports[port]);
    IOBIT_OUT dtr(0,ports[port]+4);
    IOBIT_OUT rts(1,ports[port]+4);
    IOBIT_IN dcd(7,ports[port]+6);
    IOBIT_IN ri(6,ports[port]+6);
    IOBIT_IN dsr(5,ports[port]+6);
    IOBIT_IN cts(4,ports[port]+6);
    IOBIT_LOOP l1(dtr,dsr,TRUE);
    IOBIT_LOOP l2(rts,cts,TRUE);

    INT error=0;

    cout << "Testing port:" << port
	 << " at " << hex << ports[port]
	 << endl;
    data = 0xff;
    delay(100);
    if (data()!=0xff)
    {
      error++;
      cout << "OUT:0xff "
	   << "IN:" << hex << (INT)data.val()
	   << endl;
    }
    data = 0x00;
    delay(100);
    if (data()!=0x00)
    {
      error++;
      cout << "OUT:0x00 "
	   << "IN:" << hex << (INT)data.val()
	   << endl;
    }
    if (l1.tst(cout))
      error++;
    if (l2.tst(cout))
      error++;
    cout << error << " errors" << endl;
    cout << "Port " << port;

    if (error)
    {
      cout << " failed";
    }
    else
    {
      cout << " passed";
    }
    cout << endl;
  }
  cout << "Press a key" << endl;
  cin.get();
}
