/* HC05MM6.C */
/*
 * Austausch serieller und paralleler Ports
 * ========================================
 */
#include <string.h>
#include <stdio.h>
#include <dos.h>
#include <mytypes.h>

VOID swap(UINT far *i, UINT far *j);
VOID display_status(VOID);
VOID error(CHAR *txt);

CHAR *errtxt[] = {
  "Invalid number of arguments",
  "Incorrect length in argument 1",
  "Incorrect length in argument 2",
  "Arguments must have equal type",
  "Port-number of arg1 must be in the Range of 1..4",
  "Port-number of arg2 must be in the Range of 1..4",
  "There is nothing to do",
  "Port-number of arg1 must be in the Range of 1..3",
  "Port-number of arg2 must be in the Range of 1..3",
  "There is nothing to do",
  "Only LPTx and COMx are allowed as arg1",
    "\nExchange of Ports\n"
    "=================\n"
    "Usage:\n"
    "portex                          Status-Display\n"
    "portex ?                        This display\n"
    "portex LPTx LPTy  x,y={1,2,3}   Exchange LPTs \n"
    "portex COMx COMy  x,y={1,2,3,4} Exchange COMs \n" };

VOID main(INT argc, CHAR * argv[])
{
  UINT far *fp;
  UINT far *fq;

  if (argc==1) // Status-Anzeige der Ports
  {
    display_status();
    return;
  }
  else if ((argc==2) && (argv[1][0]=='?'))
  {
  }
  else if (argc!=3)
  {
    error(errtxt[0]);
  }
  else if (strlen(argv[1])!=4)
  {
    error(errtxt[1]);
  }
  else if (strlen(argv[2])!=4)
  {
    error(errtxt[2]);
  }
  else if (strnicmp(argv[1],argv[2],3)!=0)
  {
    error(errtxt[3]);
  }
  else if (strnicmp(argv[1],"COM",3)==0) // change COM-Ports
  {
    if ((argv[1][3]<'1') || (argv[1][3]>'4'))
    {
      error(errtxt[4]);
    }
    else if ((argv[2][3]<'1') || (argv[2][3]>'4'))
    {
      error(errtxt[5]);
    }
    else if (argv[1][3]==argv[2][3])
    {
      error(errtxt[6]);
    }
    else
    {
      fp=(UINT far *)MK_FP(0x0040,(argv[1][3]-'1')*2);
      fq=(UINT far *)MK_FP(0x0040,(argv[2][3]-'1')*2);
      printf("Before: ");
      display_status();
      swap(fp,fq);
      printf("After:  ");
      display_status();
      return;
    }
  }
  else if (strnicmp(argv[1],"LPT",3)==0) // change LPT-Ports
  {
    if ((argv[1][3]<'1') || (argv[1][3]>'3'))
    {
      error(errtxt[7]);
    }
    else if ((argv[2][3]<'1') || (argv[2][3]>'3'))
    {
      error(errtxt[8]);
    }
    else if (argv[1][3]==argv[2][3])
    {
      error(errtxt[9]);
    }
    else
    {
      fp=(UINT far *)MK_FP(0x0040,(argv[1][3]-'1')*2 + 8);
      fq=(UINT far *)MK_FP(0x0040,(argv[2][3]-'1')*2 + 8);
      printf("Before: ");
      display_status();
      swap(fp,fq);
      printf("After:  ");
      display_status();
      return;
    }
  }
  else
  {
    error(errtxt[10]);
  }
  error(errtxt[11]);
}

VOID swap(UINT far *i, UINT far *j)
{
  UINT temp;
  temp=*j; *j=*i; *i=temp;
}

VOID display_status(VOID)
{
  UINT far *fp;
  CHAR * txt[] = { "COM1","COM2","COM3","COM4",
                   "LPT1","LPT2","LPT3" };
  INT i;

  for (i=0; i<7; i++)
  {
    fp=(UINT far *)MK_FP(0x0040,i*2);
    if (*fp)
      printf("%s:%3x ",txt[i],*fp);
    else
      printf("%s:--- ",txt[i],*fp);
  }
  printf("\n");
}

VOID error(CHAR *txt)
{
  printf("%s!\n\n",txt);
}
