/* HC05MM9.CPP */
/*
 * Pointer-controlled memory access
 * ================================
 */
#ifndef __TINY__
  #error must use TINY model
#else
#include <memabs.h>

VOID main(VOID)
{
  cout << "Pointer controlled memory access\n";
  UINT *mem = new UINT[80];
  cout << "at " <<hex<< mem <<endl;

  cout << "contents (read by pointers):\n";
  *mem = (UINT)(mem+2);
  *(mem+1) = _DS;
  *(mem+2) = 0xab;
  cout <<hex<< mem << ':' <<hex<< *mem <<endl;
  cout <<hex<< (mem+1) << ':' <<hex<< *(mem+1) <<endl;
  cout <<hex<< (mem+2) << ':' <<hex<< *(mem+2) <<endl;

  cout << "contents: (read by MEM-objects)\n";
  MEM<UINT> off(_DS,(UINT)mem);
  MEM<UINT> seg(_DS,(UINT)(mem+1));
  MEM<UINT> dat(_DS,(UINT)(mem+2));
  cout <<hex<< off.off() << ':' <<hex<< off() <<endl;
  cout <<hex<< seg.off() << ':' <<hex<< seg() <<endl;
  cout <<hex<< dat.off() << ':' <<hex<< dat() <<endl;

  cout << "creating MEM_P object, reading back data\n";
  MEM_P<UINT> m(_DS,(UINT)mem);
  cout << "Primary-Pointer:";
  cout <<hex<< m.seg() << ':'
       <<hex<< m.off() <<endl;
  cout << "points to      :";
  cout <<hex<< m.pointseg() << ':'
       <<hex<< m.pointoff() <<endl;
  cout << "containing data: " <<hex<< m() <<endl;
  cout << "data ++, --, &0x0f, |0xf0" <<endl;
  ++m; cout << m() << ' ';
  --m; cout << m() << ' ';
  m&=0x0f; cout << m() << ' ';
  m|=0xf0; cout << m() << ' ';
  cout <<endl;

  cout << "creating MEM_P object, reading back data\n";
  MEM_P<UINT> *mp = new MEM_P<UINT> (_DS,(UINT)mem);
  cout << "Primary-Pointer:";
  cout <<hex<< mp->seg() << ':'
       <<hex<< mp->off() <<endl;
  cout << "points to      :";
  cout <<hex<< mp->pointseg() << ':'
       <<hex<< mp->pointoff() <<endl;
  cout << "containing data: " <<hex<< (*mp)() <<endl;
  cout << "data ++, --, &0x0f, |0xf0" <<endl;
  ++(*mp); cout << (*mp)() << ' ';
  --(*mp); cout << (*mp)() << ' ';
  (*mp)&=0x0f; cout << (*mp)() << ' ';
  (*mp)|=0xf0; cout << (*mp)() << ' ';
  cout <<endl;
}
#endif
