/* HC07IN1.C */
/*
 * Tastaturinterrupt ausschalten
 * =============================
 */
#include <dos.h>
#include <time.h>
#include <bios.h>
#include <stdio.h>
#include <conio.h>
#include <mytypes.h>
#define P_IO
#include <portable.h>

VOID main(VOID)
{
  UCHAR inte;
  UCHAR key;
  time_t zeit,endzeit;
  INT stop=0;

  clrscr();
  printf("Tastatur-Interrupt wird "
	 "in den nchsten 10s ausgeschaltet\n"
         "Alle Tastendrucke sind unwirksam, "
	 "ausprobieren!\n"
         "Start mit Taste, Ende mit ESC\n");
  getch();

  time(&endzeit);
  endzeit += 10;

  // Tastatur-Interrupt ausschalten
  inte=IN_PORT(0x21);
  OUT_PORT(0x21,inte | 0x02);

  /* Tastaturpuffer rumen */
  for (;;)
  {
    UINT key;

    key=bioskey(1);
    if (key) // jeder Tastendruck wird dargestellt
    {
      printf("%4x ",bioskey(0));

      if (key==0x011b)  // ESC beendet
        break;
    }

    time(&zeit);

    if ((zeit>endzeit) && (stop==0))
    {
      // Tastatur-Interrupt einschalten
      inte=IN_PORT(0x21);
      OUT_PORT(0x21,inte & ~0x02);

      printf("\nJetzt mte die Tastatur "
	     "wieder funktionieren, Ende mit ESC\n");
      stop = 1;
    }
  }
  printf("\n\n");
}