/* HC07IT0.C */
/*
 * Variable Frequenzen durch Timer-Interrupt
 * =========================================
 * nicht den Benutzer-Timer-Interrupt 1Ch,
 * sondern 08h benutzen!
 */
#include <stdio.h>
#include <conio.h>
#include <bios.h>
#include <dos.h>
#include <mylib.h>
#ifndef MYLIB
#include "..\\source\\tic.c"
#include "..\\source\\spk.c"
#include "..\\source\\tim.c"
#endif

#define INTR 0x08    /* TIMER-Interrupt */
VOID interrupt (*oldhandler)();
VOID frequency(ULONG c, UINT div);

INT divisor = 1;
volatile count=0;

VOID interrupt timer_handler()
{
   SPK_TOGGLE();
   // PAR_TOGGLE();
   if (++count==divisor)
   {
     count=0;
     oldhandler();    /* alten Interrupt rufen */
   }
   else
   {
     OUT_PORT(0x20,0x20);
   }
}

VOID main(VOID)
{
   oldhandler = getvect(INTR); /* alten Vektor merken */

   clrscr();
   printf("Timerintervall von 53ms "
          "schrittweise verkleinern\n");
   printf("Kontrolle mit Lautsprecher, "
          "weiter jeweils mit Taste\n");
   printf("!! Nicht mit CTRL-BREAK unterbrechen !!\n");
   getch();

   disable(); setvect(INTR, timer_handler); enable();
   frequency(0x10000L,1);
   frequency(0x8000L,2);
   frequency(0x4000L,4);
   frequency(0x2000L,8);
   frequency(0x1000L,16);
   frequency(0x0800L,32);
   frequency(0x0400L,64);
   frequency(0x0200L,128);
   frequency(0x0100L,256);
   frequency(0x0080L,512);
   disable(); setvect(INTR, oldhandler); enable();
}

VOID frequency(ULONG c, UINT div)
{
  FLOAT f = 4770000.0/(4*c);
  printf("\nFrequenz: %6.2f Hz "
         "Periodendauer: %6.2f us\n",f,1000000L/f);
  disable(); divisor=div; tim0_set((UINT)c); enable();
  do { tic_show(); } while (bioskey(1)==0); bioskey(0);
}
