/* HC07IT1.C */
/*
 * Texteingabe mit Hintergrundprogramm
 * ===================================
 */
#include <stdio.h>
#include <conio.h>
#include <bios.h>
#include <dos.h>
#include <mylib.h>
#ifndef MYLIB
#include "..\\source\\tim.c"
#include "..\\source\\spk.c"
#endif

VOID tim0_div(VOID);

#define INTR 0x08    /* TIMER-Interrupt */

VOID interrupt ( *oldhandler)();

INT divi = 1;
volatile count=0;
volatile INT spk = 1;
volatile INT fun = 1;
volatile INT x=78, y=7;
volatile INT dx=1, dy=1;
UINT fun_old_char;
INT fun_start=1;
UINT far *fp;

VOID interrupt handler()
{
   if (spk)
   {
     spk_toggle();
     par_toggle();
   }
   if (fun)
   {
     if (fun_start)
     {
       fp = (UINT far *) MK_FP(0xb800,(y*80+x)*2);
       fun_old_char=*fp;
       fun_start=0;
     }
     *fp=fun_old_char;
     x += dx; y += dy;
     fp = (UINT far *) MK_FP(0xb800,(y*80+x)*2);
     fun_old_char=*fp; *fp=0x8702;
     if ((x==79)||(x==0)) { dx *= -1; }
     if ((y==24)||(y==0)) { dy *= -1; }
   }
   else
   {
     if (!fun_start)
     {
       *fp=fun_old_char;
       fun_start=1;
     }
   }
   if (++count==divi)
   {
     count=0;
     oldhandler();    /* alten Interrupt rufen */
   }
   outportb(0x20,0x20);
   enable();
}

VOID main(VOID)
{  /* alten Vektor merken */
   oldhandler = getvect(INTR);
   clrscr();
   printf("Texteingabe mit Hintergrundprogramm\n"
          "===================================\n"
	  "PgUp Schaltet den Lautsprecher ein\n"
	  "PgDn Schaltet den Lautsprecher aus\n"
	  "CuUp Schaltet das Mnnchen ein\n"
	  "CuDn Schaltet das Mnnchen aus\n");
   printf("CuLt verzgert\n",
	  "CuRt beschleunigt\n",
	  "ESC  beendet\n");
   fflush(stdout);
   /* neuen Vektor installieren */
   disable(); divi=1; setvect(INTR,handler); enable();
   for (;;)
   {
     UINT key;
     key=bioskey(0);
     switch(key)
     {
     case 0x4900 /* PgUp */:
       spk = 1; break;
     case 0x5100 /* PgDn */:
       spk = 0; break;
     case 0x4800 /* CuUp */:
       fun = 1; break;
     case 0x5000 /* CuUp */:
       fun = 0; break;
     case 0x4b00 /* CuLt */:
       divi=(divi==1)?1:divi/2;
       tim0_div(); break;
     case 0x4d00 /* CuRt */:
       divi=(divi==16)?16:divi*2;
       tim0_div(); break;
     case 0x011b /* ESC  */:
       goto end;
     }
     if (key & 0x00ff) /* ASCII-Key */
       putchar(key&0x00ff);
   }
end:
   fun=0; spk=0; delay(100);
   divi=1; tim0_div();
   /* alten Vektor wiederherstellen */
   disable(); setvect(INTR,oldhandler); enable();
}

VOID tim0_div(VOID)
{
  ULONG count = 0x10000L;
  if (divi>1) count /= divi;
  disable(); tim0_set((INT)count); enable();
}

