/* HC07IV2.CPP */
/*
 * Interrupt-Service-Routine
 * =========================
 */
#include <dos.h>
#include <constream.h>
#include <mytypes.h>

VOID interrupt far prt_scr(VOID)
{
  UCHAR far *bild=(UCHAR far *)MK_FP(0xb800,0);
  (*bild)++;
}

VOID main(VOID)
{
  ULONG far *ip;
  struct SREGS sr;
  ULONG alter_vektor;

  constream con;
  con.clrscr();
  con << "Umlenkung eines Interruptvektors "
         "auf das eigene Programm\n";

  ip=(ULONG far *)MK_FP(0,20);
  con << "Alter PrintScreen-Interrupt-Vektor: "
      << setfill('0') << setw(8) << hex
      << *ip << endl;

  disable();
  alter_vektor = *ip;
  enable();

  /* Umlenken des PrintScreen-Interrupt */
  segread(&sr);
  disable();
  *ip=(ULONG)MK_FP(sr.cs,(UINT)prt_scr);
  enable();
  con << "Neuer PrintScreen-Interrupt-Vektor: "
      << setfill('0') << setw(8) << hex
      << *ip << endl;
  con << "Die neue Interrupt-Service-Routine "
         "verndert den Inhalt\n"
	 "der Bildschirmzelle 0,0 links oben "
         "mit PRTSCR\n"
	 "Jede andere Taste "
         "stellt den alten Vektor wieder her\n";

  do {} while (!kbhit()); getch();

  disable();
  *ip = alter_vektor;
  enable();

  con << "Wiederhergestellter alter Vektor: "
      << setfill('0') << setw(8) << hex
      << *ip << endl;
  getch();
}
