/* HC07IV2A.C */
/*
 * Interrupt-Service-Routine
 * =========================
 */
#include <dos.h>
#include <constream.h>
#include <mytypes.h>

VOID interrupt far prt_scr(...)
{
  UCHAR far *bild=(UCHAR far *)MK_FP(0xb800,0);
  (*bild)++;
}

VOID main(VOID)
{
  ULONG far *ip;
  struct SREGS sr;
  VOID interrupt (*alter_vektor)(...);

  constream con;
  con.clrscr();
  con << "Umlenkung eines Interruptvektors\n";

  ip=(ULONG far *)MK_FP(0,20);
  con << "Alter PrintScreen-Interrupt-Vektor: "
      << setfill('0') << setw(8) << hex
      << *ip << endl;

  alter_vektor = getvect(5);

  // Umlenken des PrintScreen-Interrupt
  segread(&sr);

  setvect(5,prt_scr);

  con << "Neuer PrintScreen-Interrupt-Vektor: "
      << setfill('0') << setw(8) << hex
      << *ip << endl;
  con << "Die neue Interrupt-Service-Routine "
         "verndert den Inhalt\n"
	 "der Bildschirmzelle 0,0 links oben "
         "mit PRTSCR\n"
	 "Jede andere Taste "
         "stellt den alten Vektor wieder her\n";

  do {} while (!kbhit()); getch();

  setvect(5,alter_vektor);

  con << "Wiederhergestellter alter Vektor: "
      << setfill('0') << setw(8) << hex
      << *ip << endl;
  getch();
}
