/* HC07IV3.C */
/*
 * Funktionen in der Interrupt-Service-Routine
 * ===========================================
 */
#ifdef __TURBOC__

#ifdef __TINY__

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <mytypes.h>

#ifdef __cplusplus
const UINT STACKLEN=5000;
#else
#define STACKLEN 5000
#endif

static CHAR temporary_stack[STACKLEN];
static UINT old_stackp;
static UINT old_stacks;

static UINT counter=0;

VOID interrupt far prt_scr()
{
  asm {
    cli
    // make TINY conditions cs=ds=es
    mov ax,cs
    mov es,ax
    mov ds,ax
    // remind old_stack
    mov old_stackp,sp
    mov ax,ss
    mov old_stacks,ax
    // make new_stack
    mov ax,cs
    mov ss,ax
    mov sp,OFFSET temporary_stack
    add sp,STACKLEN-1
    sti
      }
  counter++;
  cprintf("COUNTER:%i\n\r",counter);
  asm {
    // get old_stack
    cli
    mov ax,old_stackp
    mov bx,old_stacks
    mov ss,bx
    mov sp,ax
    sti
      }
}

VOID main(VOID)
{
  struct SREGS sr;
  VOID interrupt (*alter_vektor)();

  clrscr();
  directvideo=1;
  printf("Benutzung hherwertiger Funktionen "
         "in der Interrupt-Service-Routine\n");
  segread(&sr);
  if (sr.cs!=sr.ds)
  {
    printf("TINY-Modell verwenden!\n");
    getch();
    return;
  }

  alter_vektor=getvect(5);

  setvect(5,prt_scr);
  printf("Vektor umgelenkt\n");

  do {} while (!kbhit());

  setvect(5,alter_vektor);
  getch();
}

#else
  #error Must use TINY model
#endif // __TINY__

#else
  #error Must use BORLAND compiler
#endif // __TURBOC__
