/* HC07IV4.CPP */
/*
 * Timer-Interrupt umlenken
 * ========================
 */
#include <dos.h>
#include <mytypes.h>

#define INTR 0x1C    // TIMER-Interrupt

VOID interrupt ( *oldhandler)(...);

volatile INT count=0;

VOID interrupt handler(...)
{
   disable();       // Interrupts ausschalten
   count++;         // Zhler weiterzhlen
   enable();        // Interrupts einschalten
   oldhandler();    // alten Interrupt rufen
}

VOID main(VOID)
{  // alten Vektor merken
   oldhandler = getvect(INTR);
   // neuen Vektor installieren
   setvect(INTR, handler);
   // zhlen und warten
   while (count < 20)
     cout << count << ' ' << endl ;
   // alten Vektor wiederherstellen
   setvect(INTR, oldhandler);
}
