/* HC07IV5.C */
/*
 * Tastatur-Interrupt umlenken
 * ===========================
 */
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <mytypes.h>

#define INTR 0x9    /* Tastatur-Interrupt */

VOID interrupt ( *oldhandler)();

VOID interrupt handler()
{
   UINT far * kp;
   oldhandler();    /* alten Interrupt rufen */
   disable();       /* Interrupts ausschalten */
   kp = (UINT far *)MK_FP(0x0040,0x001a);
   kp = (UINT far *)MK_FP(0x0040,*kp);
   if ((*kp & 0x0060) == 0x0060)
     *kp = (*kp) & ~0x0020;
   else if ((*kp & 0x0040) == 0x0040)
     *kp = (*kp) | 0x0020;
   enable();        /* Interrupts einschalten */
}

VOID TastenTest(VOID)
{
   INT c;
   printf("\nTastaturecho, Ende mit CTRL-C\n");
   do
   {
     c=getch();
     printf("%c",c);
   }
   while ((c)!=3);
   printf("\n");
}

VOID main(VOID)
{
   clrscr();
   printf("Testen Sie Ihre Tastatur!\n");
   TastenTest();

   printf("Neue Interrupt-Service-Routine "
	  "vertauscht Gro- und Kleinbuchstaben\n");

   /* alten Vektor merken */
   oldhandler = getvect(INTR);
   /* neuen Vektor installieren */
   setvect(INTR, handler);
   TastenTest();

   /* alten Vektor wiederherstellen */
   setvect(INTR, oldhandler);
   getch();
}
