/* HC07IV5.CPP */
/*
 * Tastatur-Interrupt umlenken
 * ===========================
 */
#include <dos.h>
#include <conio.h>
#include <mytypes.h>

#define INTR 0x9    // Tastatur-Interrupt

VOID interrupt ( *oldhandler)(...);

VOID interrupt handler(...)
{
   UINT far * kp;
   oldhandler();    // alten Interrupt rufen
   disable();       // Interrupts ausschalten
   kp = (UINT far *)MK_FP(0x0040,0x001a);
   kp = (UINT far *)MK_FP(0x0040,*kp);
   if ((*kp & 0x0060) == 0x0060)
     *kp = (*kp) & ~0x0020;
   else if ((*kp & 0x0040) == 0x0040)
     *kp = (*kp) | 0x0020;
   enable();        // Interrupts einschalten
}

VOID main(VOID)
{
   cout << "Tastaturinterrupt umlenken" << endl;
   cout << "Klein/Grobuchstaben werden vertauscht\n";
   cout << "Ende mit CTRL-C\n";
   oldhandler = getvect(INTR); // alten Vektor merken
   setvect(INTR, handler);     // neuer Vektor
   UCHAR c;
   do
   {
     c=getch();
     cout << c;
   }
   while ((c)!=3);
   setvect(INTR, oldhandler);
}
