/* HC08IB0.CPP */
/*
 * BIOS-Funktionen testen
 * ======================
 */
#include <portstrm.h>
#include <stdlib.h>
#include <dos.h>
#include <mytypes.h>

VOID main(VOID)
{
  union REGS r;
  CHAR temp[20];
  INT lfw;

  cout << "Testen einiger BIOS-Interrupts\n"
       << "==============================\n";
  cout << "Speicherkapazitt feststellen, "
          "Interrupt 0x12\n";
  int86(0x12,&r,&r);
  cout << "Der Speicher ist " << r.x.ax
       << " kByte gro\n";
  cout << "Taste"; cin.get();
  cout << "Ausstattung feststellen, Interrupt 0x11\n";
  int86(0x11,&r,&r);
  cout << "Bitkombination gelesen : "
       << setfill('0') << setw(4) << hex
       << r.x.ax << " HEX\n";
  cout << "Bitkombination gelesen : "
       << setfill('0') << setw(16) << hex
       << itoa(r.x.ax,temp,2) << " BIN\n";
  cout << "Bitkombination         : ddsgsssDffvvrr7f\n";
  cout << "Laufwerk               : "
       << (r.x.ax & 0x0001) << endl;
  cout << "Arithmetik-Prozessor   : "
       << ((r.x.ax & 0x0002) ? "nein" : "ja") << endl;
  cout << "RAM auf Hauptplatine   : "
       << ((r.x.ax & 0x000C)>>2) << "x16k\n";
  cout << "Bildschirmmodus        : ";
  switch ((r.x.ax&0x0030)>>4)
  {
  case 0: cout << "unklar"; break;
  case 1: cout << "40x25 Farbe"; break;
  case 2: cout << "80x25 Farbe"; break;
  case 3: cout << "80x25 s/w"; break;
  }
  cout << endl;
  cout << "Anzahl der Laufwerke   : "
       << ((r.x.ax & 0x00C0)>>6) << endl;
  cout << "DMA mglich            : "
       << ((r.x.ax & 0x0100) ? "nein" : "ja") << endl;
  cout << "Anzahl der RS232-Karten: "
       << ((r.x.ax & 0x0E00)>>9) << endl;
  cout << "Game-Port vorhanden    : "
       << ((r.x.ax & 0x1000) ? "nein" : "ja") << endl;
  cout << "Serieller Drucker      : "
       << ((r.x.ax & 0x2000) ? "nein" : "ja") << endl;
  cout << "Druckeranzahl          : "
       << ((r.x.ax & 0xC000)>>12) << endl << endl;
  cout << "Taste"; cin.get();
  cout << "Laufwerke feststellen, Interrupt 0x13\n";
  for (lfw=0; lfw<5; lfw++)
  {
    r.h.ah=0x15;
    if (lfw<2) r.h.dl=lfw;
    else r.h.dl=lfw+0x80-2;
    int86(0x13,&r,&r);
    cout << "Laufwerk " << lfw <<": Laufwerkstyp :";
    switch(r.h.ah)
    {
    case 0:
      cout << "kein Laufwerk";
      break;
    case 1:
      cout << "Floppy ohne Diskettenwechselsignal";
      break;
    case 2:
      cout << "Floppy mit Diskettenwechselsignal";
      break;
    case 3:
      cout << "Festplatte: ";
      cout << "Anzahl der 512-byte-Sektoren: "
           << setw(8) << dec << (r.x.cx*65536L+r.x.dx);
      break;
    }
    cout << endl;
  }
  cout << "Taste"; cin.get();
  cout << "Aktuelle Laufwerksparameter, "
       << "Interrupt 0x13" << endl;
  for (lfw=0; lfw<5; lfw++)
  {
    r.h.ah=0x08;
    if (lfw<2) r.h.dl=lfw;
    else r.h.dl=lfw+0x80-2;
    int86(0x13,&r,&r);
    cout << "Laufwerk: "
            "Status(HEX)/Laufwerke/"
            "Seitenzahl/Sektoren/Spuren\n";
    cout << lfw << ':'
	 << setfill('0') << setw(3) << dec
         << (INT)r.h.ah << '/'
	 << setfill('0') << setw(3) << dec
         << (INT)r.h.dl << '/'
	 << setfill('0') << setw(3) << dec
         << (INT)r.h.dh << '/'
	 << setfill('0') << setw(3) << dec
         << (INT)r.h.cl << '/'
	 << setfill('0') << setw(3) << dec
         << (INT)r.h.ch;
  }
  cout << endl;
  cout << "Taste"; cin.get();
  r.h.ah = 0x0f;
  int86(0x10,&r,&r);
  cout << "Bildschirmmodus : " << hex
       << (INT)r.h.al << endl;
  cout << "Bildschirmseite : "
       << (INT)r.h.bh << endl;
  cout << "Zeichen/Zeile   : "
       << (INT)r.h.ah << endl;
  cout << "Mit TASTE lassen wir einen Teil "
          "des Bildschirms nach oben rollen\n";
  cout << "und verndern dabei das Attribut\n";
  cin.get();
  r.h.ah=0x06;
  r.h.al=4;
  r.h.bh = 0x71;
  r.h.ch = 5;
  r.h.cl = 10;
  r.h.dh = 15;
  r.h.dl = 40;
  int86(0x10,&r,&r);
  cout << "Taste"; cin.get();
  cout << "\nUhr ablesen und Tastatur prfen\n";
  do
  {
    r.h.ah=0x02;
    int86(0x1a,&r,&r);
    cout << hex
	 << (INT)r.h.ch <<':'
         << (INT)r.h.cl <<':'
         << (INT)r.h.dh
	 << endl;
    delay(1000);
    r.h.ah=1;
    int86(0x16,&r,&r);
  }
  while(r.x.flags & 0x0040);
}
