/* HC09DM1.C */
/*
 * DOS: Wo steht was im Speicher
 * =============================
 */
/*
Literaturhinweise: 
  Scharl,Schchle,PROLOAD,PC-NEWS 2/89, S.29-31
  Tom Hogan,
    Die PC-Referenz fr Programmierer,
    Microsoft-Press, 1988, S 162-166
*/

#include <dos.h>
#include <stdio.h>
#include <mytypes.h>
#include <portable.h>

VOID main(VOID)
{
  union REGS r;
  struct SREGS s;
  UCHAR far * mcb_kennung;
  UINT far * list_beg;
  UINT far * psp;
  UINT far * length;
  INT block_nr=0;
  
  r.h.ah=0x52;
  intdosx(&r,&r,&s);
  list_beg = (UINT far *)MK_FP(s.es,r.x.bx-2);
  mcb_kennung = (UCHAR far *)MK_FP(*list_beg,0);

  while ((*mcb_kennung=='M') || (*mcb_kennung=='Z'))
  {
    psp = (UINT far *)(mcb_kennung+1);
    length = (UINT far *)(mcb_kennung+3);
    printf("\n%2i:%4x %4x %4x ",
      block_nr,(UINT)FP_SEG(mcb_kennung),*psp,*length);
    { /* Memory-Control-Block */
      INT i;
      UCHAR far * c = mcb_kennung+5;
      for (i=5; i<16; i++)
      {
        printf("%2x ",*c);
        c++;
      }
      printf("\n                  ");
      c = mcb_kennung+5;
      for (i=5; i<16; i++)
      {
        if ((*c<32) || (*c>127))
          printf("%2c ",'.');
        else
          printf("%2c ",*c);
        c++;
      }
      printf("\n");
    }
    { /* PSP */
      UCHAR far * environ;
      UINT count,i;

      psp = (UINT far *)MK_FP(*psp,0);
      if (*psp==0x20cd) /* INT 20H, Termination-Code */
      {
        printf("Standard PSP-Format at %4x\n",
          FP_SEG(psp));
        { /* PrINT Environment */
	  UINT far * environ_adr =
            (UINT far *)MK_FP(FP_SEG(psp),0x2c);
	  environ = (UCHAR far *)MK_FP(*environ_adr,0);

          printf("Environment at: %lp\n",environ);
          while (!(*environ==0 && *(environ+1)==0))
          {
            printf("%c",*environ);
            environ++;
          }
          printf("\n");

          count = *(environ+2);
          environ += 4;
          printf("Actual process: ");
          for (i=0; i<count; i++)
          {
            while (*environ)
            {
              printf("%c",*environ);
              environ++;
            }
            printf(" ");
            environ++;
          }
          printf("\n");
	}
      }
      else
        printf("Unknown PSP-Format at %4x\n",FP_SEG(psp));
    }
    if (*mcb_kennung=='Z') break;
    mcb_kennung =
      (UCHAR far *)MK_FP(FP_SEG(mcb_kennung) +
      (*length) + 1, 0);
    block_nr++;
  }
}
