/* HC05MM13.CPP */
/*
 * Analyse Tastaturbuffer
 * ======================
 */
#include <bios.h>
#include <portable.h>
#include <keybios.hpp>

VOID main(VOID)
{
  IBIOS<UINT> head(keybd_q_head);
  IBIOS<UINT> tail(keybd_q_tail);
  IBIOS<UINT> beg(keybd_begin);
  IBIOS<UINT> end(keybd_end);
  cout << endl;
  cout << "Analyzing keyboard queue" << endl
       << "========================" << endl;
  cout << "BEGIN : ";
  cout << setw(2) << setfill('0') << hex
       << beg.pointoff() << endl;
  cout << "END   : ";
  cout << setw(2) << setfill('0') << hex
       << end.pointoff() << endl;
  cout << "HEAD  : ";
  cout << setw(2) << setfill('0') << hex
       << head.pointoff() << endl;
  cout << "TAIL  : ";
  cout << setw(2) << setfill('0') << hex
       << tail.pointoff() << endl;

  for (INT i=0; i<16; i++)
  {
    cout << "QUEUE adr ";
    BIOS<UINT> q = (beg.pointoff()+2*i);
    cout << setw(8) << setfill('0') << hex
         << (ULONG)q.addr() << ':';
    cout << setw(4) << setfill('0') << hex
         << q.val();
    INT h=0;
    if ( (beg.pointoff()+i)==head.pointoff() )
      h|=1;
    if ( (beg.pointoff()+i)==tail.pointoff() )
      h|=2;
    switch (h)
    {
    case 0: cout << " "; break;
    case 1: cout << " head "; break;
    case 2: cout << " tail "; break;
    case 3: cout << " head+tail "; break;
    }
    cout << endl;
  }
}
