/* HC06KB2.CPP */
/*
 * Tastaturbuffer nach jeder Taste
 * ===============================
 */
#include <bios.h>
#include <portable.h>
#include <keybios.hpp>

VOID main(VOID)
{
  BIOS<UINT> head(keybd_q_head);
  BIOS<UINT> tail(keybd_q_tail);
  BIOS<UINT> beg(keybd_begin);
  BIOS<UINT> end(keybd_end);
  cout << endl;
  cout << "Analyzing keyboard queue" << endl
       << "========================" << endl
       << "End with CTRL-BREAK" << endl << endl;
  cout << "B:" << hex << (UINT)beg()
       << " E:" << hex << (UINT)end() << endl;

  KBDQUEUE q;

  for (;;)
  {
    q.set(beg());
    head(); tail();
    if ( head.changed()||tail.changed() )
    {
      cout << hex << "H:" << (UINT)head()
	   << hex << " T:" << (UINT)tail() << endl;
      for (INT i=0; i<16; i++)
      {
	if (i==8) cout << endl;
	cout << setw(4) << setfill('0') << hex << q();
	q.next();
	INT h=0;
	if ( (beg()+2*i)==head.val() ) h|=1;
	if ( (beg()+2*i)==tail.val() ) h|=2;
	switch (h)
	{
	case 0: cout << "   "; break;
	case 1: cout << "a  "; break;
	case 2: cout << "e  "; break;
	case 3: cout << "a+e"; break;
	}
      }
      cout << endl << endl;
    }
  }
}
