/* HC06KB6.CPP */
/*
 * Tastatur-Interrupt umlenken
 * ===========================
 */
#ifndef __TINY__
  #error Use TINY memory model
#else

#undef MYHISTORY
#define __DEBUG 0
#include <constream.h>
#include <keybios.hpp>
#ifndef MYLIB
#include "\mylib\source\keybios.cpp"
#endif

#define INTR 0x9    // Tastatur-Interrupt

VOID interrupt (*oldhandler)(...);
IBIOS<UINT> head(keybd_q_head);
KBD kbd;

const UINT STACKLEN=5000;
static CHAR temporary_stack[STACKLEN];
static UINT old_stackp;
static UINT old_stacks;

VOID interrupt handler(...)
{
  oldhandler();    // alten Interrupt rufen

  asm {
    cli
    // make TINY conditions cs=ds=es
    mov ax,cs
    mov es,ax
    mov ds,ax
    // remind old_stack
    mov old_stackp,sp
    mov ax,ss
    mov old_stacks,ax
    // make new_stack
    mov ax,cs
    mov ss,ax
    mov sp,OFFSET temporary_stack
    add sp,STACKLEN-1
      }

  UINT key=head();
  if ((key & 0x0060) == 0x0060)
    head = (key & ~0x0020);
  else if ((key & 0x0040) == 0x0040)
    head = (key | 0x0020);

  kbd.put();

  asm {
    // get old_stack
    mov ax,old_stackp
    mov bx,old_stacks
    mov ss,bx
    mov sp,ax
    sti
      }
}

VOID main(VOID)
{
  cout << endl;
  cout << "Tastaturinterrupt umlenken" << endl;
  cout << "Klein/Grobuchstaben werden vertauscht\n";
  cout << "Ende mit ESC\n";
  oldhandler = getvect(INTR);
  setvect(INTR, handler);
  for (;;)
  {
    getch();
    if ((kbd.key())==0x011b) break;
    kbd.out_history();
  }
  setvect(INTR, oldhandler);
}
#endif // __TINY__
