
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

unsigned segment;
unsigned segment1;

  union REGS r;
  struct SREGS s;

#define int_keyb 0x16
#define int_dummy 0x7e

  struct address { char far *p; };

  /* address of the keyboard interrupt */
  struct address far *addr = (struct address far *) (int_keyb * 4);
  /* address of the dummy interrupt */
  struct address far *addr1 = (struct address far *) (int_dummy * 4);


void write_video (char *, unsigned char);
void interrupt far tsr_ap (void);
void initvideo (void);
void interrupt far tsr_remove (void);


void interrupt far tsr_ap(void)
{
  /* das Tatstaturzeichen 'z' wird invertiert */

}


void interrupt far tsr_remove (void)
{
  addr->p = (char far *) 0;
  addr1->p = (char far *) 0;

  /* deallocate memory */
  s.es=segment;
  r.h.ah=0x49;
  int86x (0x21,&r,&r,&s);
  s.es=segment1;
  r.h.ah=0x49;
  int86x (0x21,&r,&r,&s);
}

/* terminate but keep resident */
void tsr (unsigned size)
{

  r.h.ah = 0x31;  /* terminate and stay resident */
  r.h.al = 0;     /* return code */
  r.x.dx = size;
  int86(0x21, &r, &r);
}


void extern main (int argc,char *argv[]){

  long adr;
  unsigned char far *pc;
  char zahl[10];

  if (argc>1)

    switch (toupper(argv[1][0])) {

    case 'R': if (addr1->p == (char far *) 0) {
		initvideo();
		write_video ("Programm noch nicht geladen",0x7f);
		exit (1);
	      }
	      initvideo();
	      write_video  ("Programm wird entfernt",0x7f);
	      int86 (int_dummy,&r,&r);
	      exit (1);

    case 'H': /* Hilfefunktion */
    case '?': /* Hilfefunktion */
	      initvideo();
	      write_video ("Testprogramm fuer residente Programme",0x7f);
	      write_video ("Optionen: R entfernen, H Hilfe, V Vektoren ruecksetzen",0x7f);
	      exit (1);

    case 'V': /* Vektoren entfernen */
	      initvideo();
	      write_video ("Vektoren wurden zurueckgesetzt",0x7f);
	      addr->p=(char far *) 0;
	      addr1->p=(char far *) 0;
	      exit (1);

    case 'Y': /* Programm ueber Interrupt ausfuehren */
	      addr->p=(char far *) tsr_ap;
	      int86 (5,&r,&r);
	      exit (1);

    default:  write_video ("Falsches Argument",0x7f);
	      exit (1);
    }

  /* Programm soll resident gemacht werden */
  if (addr1->p == (char far *) 0) { /* Pruefung */
    initvideo();
    write_video ("Programm wird installiert",0x7f);

    addr->p=(char far *) tsr_ap;
    addr1->p=(char far *) tsr_remove;

    /* Programm-Segment-Praefix-bestimmen */
    r.h.ah=0x62;
    int86 (0x21,&r,&r);
    /* Segmentadresse des PSP in bx */
    adr=(long)r.x.bx*0x10000;
    pc=(unsigned char far *) adr;
    /* Segmentadresse des environment in 0x2c */
    segment=*(pc+0x2c);
    pc++;
    segment=segment+*(pc+0x2c)*256;
    pc--;
    segread (&s);
    segment1=s.es;
    tsr (0x300);

  } else {
    write_video ("Programm bereits installiert",0x7f);
    exit (1);
  }
}
