
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

unsigned segment;
unsigned segment1;

  union REGS r;
  struct SREGS s;

#define int_prtscr 0x05
#define int_dummy 0x7e

  struct address { char far *p; };

  /* address of the print screen interrupt */
  struct address far *addr = (struct address far *) (int_prtscr * 4);
  /* address of the dummy interrupt */
  struct address far *addr1 = (struct address far *) (int_dummy * 4);


void write_video (char *, unsigned char);
void interrupt far tsr_ap (void);
void initvideo (void);
void interrupt far tsr_remove (void);


/* display a string with specified attribute */
void write_video (p, attrib)

char *p;
unsigned char attrib;

{
  r.h.ah=3; /* read cursor */
  r.h.bh=0; /* video page */
  int86(0x10, &r, &r);
  r.h.dl=0; /* column coordinate */
  r.h.dh++; /* row coordinate */
  r.h.ah=2; /* set cursor */
  r.h.bh=0; /* video page */
  int86(0x10, &r, &r);

  while (*p) {
    r.h.ah = 10; /* write character function */
    r.h.bh = 0; /* assume active display page is 0 */
    r.x.cx = 1; /* number of times to write the character */
    r.h.al = *p++; /* character */
    r.h.bl = attrib; /* attribute */
    int86(0x10, &r, &r);
    r.h.ah=3; /* read cursor */
    r.h.bh=0; /* video page */
    int86(0x10, &r, &r);
    r.h.dl++; /* column coordinate */
    r.h.dh; /* row coordinate */
    r.h.ah=2; /* set cursor */
    r.h.bh=0; /* video page */
    int86(0x10, &r, &r);
  }
  r.h.ah=3; /* read cursor */
  r.h.bh=0; /* video page */
  int86(0x10, &r, &r);
  r.h.dl=0; /* erste Spalte */
  r.h.dh++; /* naechste Zeile */
  r.h.ah=2; /* set cursor */
  r.h.bh=0; /* video page */
  int86(0x10, &r, &r);
}

void initvideo (void)
{

  r.h.ah=0;
  r.h.al=3;
  int86 (0x10, &r, &r);

  /* set cursor */
  r.h.ah=2; /* cursor addressing function */
  r.h.bh=0; /* video page */
  r.h.dl=0; /* column coordinate */
  r.h.dh=0; /* row coordinate */
  int86(0x10, &r, &r);
}


void interrupt far tsr_ap(void)
{
  initvideo();
  write_video ("Hallo0",0xf7);
  write_video ("Hallo1",0xf7);
  write_video ("Hallo2",0xf7);
  write_video ("Hallo3",0xf7);
  write_video ("Hallo4",0xf7);
}


void interrupt far tsr_remove (void)
{
  addr->p = (char far *) 0;
  addr1->p = (char far *) 0;

  /* deallocate memory */
  s.es=segment;
  r.h.ah=0x49;
  int86x (0x21,&r,&r,&s);
  s.es=segment1;
  r.h.ah=0x49;
  int86x (0x21,&r,&r,&s);
}

/* terminate but keep resident */
void tsr (unsigned size)
{

  r.h.ah = 0x31;  /* terminate and stay resident */
  r.h.al = 0;     /* return code */
  r.x.dx = size;
  int86(0x21, &r, &r);
}


void extern main (int argc,char *argv[])
{

  long adr;
  unsigned char far *pc;
  char zahl[10];

  if (argc>1)

    switch (toupper(argv[1][0])) {

    case 'R': if (addr1->p == (char far *) 0) {
		initvideo();
		write_video ("Programm noch nicht geladen",0x7f);
		exit (1);
	      }
	      initvideo();
	      write_video  ("Programm wird entfernt",0x7f);
	      int86 (int_dummy,&r,&r);
	      exit (1);

    case 'H': /* Hilfefunktion */
    case '?': /* Hilfefunktion */
	      initvideo();
	      write_video ("Testprogramm fuer residente Programme",0x7f);
	      write_video ("Optionen: R entfernen, H Hilfe, V Vektoren ruecksetzen",0x7f);
	      exit (1);

    case 'V': /* Vektoren entfernen */
	      initvideo();
	      write_video ("Vektoren wurden zurueckgesetzt",0x7f);
	      addr->p=(char far *) 0;
	      addr1->p=(char far *) 0;
	      exit (1);

    case 'Y': /* Programm ueber Interrupt ausfuehren */
	      addr->p=(char far *) tsr_ap;
	      int86 (5,&r,&r);
	      exit (1);

    default:  write_video ("Falsches Argument",0x7f);
	      exit (1);
    }

  /* Programm soll resident gemacht werden */
  if (addr1->p == (char far *) 0) { /* Pruefung */
    initvideo();
    write_video ("Programm wird installiert",0x7f);

    addr->p=(char far *) tsr_ap;
    addr1->p=(char far *) tsr_remove;

    /* Programm-Segment-Praefix-bestimmen */
    r.h.ah=0x62;
    int86 (0x21,&r,&r);
    /* Segmentadresse des PSP in bx */
    adr=(long)r.x.bx*0x10000;
    pc=(unsigned char far *) adr;
    /* Segmentadresse des environment in 0x2c */
    segment=*(pc+0x2c);
    pc++;
    segment=segment+*(pc+0x2c)*256;
    pc--;
    segread (&s);
    segment1=s.es;
/*
    itoa(segment,zahl,16);
    write_video (zahl,0x7f);
    write_video ("  ",0x7f);

    itoa(s.cs,zahl,16);
    write_video (zahl,0x7f);
    write_video ("  ",0x7f);

    itoa(s.ds,zahl,16);
    write_video (zahl,0x7f);
    write_video ("  ",0x7f);

    itoa(s.es,zahl,16);
    write_video (zahl,0x7f);
    write_video ("  ",0x7f);

    itoa(s.ss,zahl,16);
    write_video (zahl,0x7f);
*/
    tsr (0x300);

  } else {
    write_video ("Programm bereits installiert",0x7f);
    exit (1);
  }
}
