#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

unsigned char far *pc;

void TypeOffset (char *,int);

void main ()
{
  union REGS r;

  int *ptr;

  long adr;
  unsigned int i,j;

  r.h.ah=0x62;
  int86 (0x21,&r,&r);

  printf ("PSP-Segment: %x %x Analyse des Programmsegment Praefix\n",r.x.bx,_psp);

  adr=(long)r.x.bx*0x10000;
  pc=(unsigned char far *) adr;

  TypeOffset ("Int20h",0);
  TypeOffset ("TopMem",2);
  TypeOffset ("TermIP",0xa);
  TypeOffset ("TermCS",0xc);
  TypeOffset ("CtrlIP",0xe);
  TypeOffset ("CtrlCS",0x10);
  TypeOffset ("CritIP",0x12);
  TypeOffset ("CritCS",0x14);
  TypeOffset ("Enviro",0x2c);

  for (i=0;i<16;i++) {
    printf ("\n%2x:",i*16);
    for (j=0;j<16;j++) { printf (" %2x",*pc);pc++; }
    printf (" ");
    pc=pc-16;
    for (j=0;j<16;j++) {
      if (( *pc>=32 ) && ( *pc<=127 )) printf ("%c",*pc);
      else printf (".");
      pc++;
    }
  }
}

void TypeOffset (char *Text,int off)
{
  printf ("%s:(%2x): %4x\n",Text,off,(int)(*(pc+off)+*(pc+off+1)*256));
}

