
// BILD_CPP

#include <int.h>
#include <bios.h>
#include <dos.h>
#include <disp.h>
#include <sound.h>
#include <tsr.h>
#include <string.h>
#include <stdlib.h>

#define BILDLEN 2000
#define TRUE 1
#define FALSE 0

unsigned int far *bild;
unsigned int far *bp;
unsigned int bild_alt[BILDLEN];
unsigned int *bap;
unsigned int bild_spr[BILDLEN];
unsigned int *bsp;
unsigned int bild_ver[2*BILDLEN+1];
unsigned int *bvp;

unsigned int bild_rec[BILDLEN];
unsigned int *brp;

int disp_getpage(void)
{ REGS r;
  r.h.ah=0x0f; // Get_video_info
  int86(0x10,&r,&r);
  return r.h.bh;
}

void disp_setpage(int page)
{ REGS r;
  r.h.ah=0x05; // Set page
  r.h.al=page;
  int86(0x10,&r,&r);
}

void bild_comp(void)
{ bp=bild; bap=bild_alt; bvp=bild_ver;
  for (unsigned int i=0; i<BILDLEN; i++,bp++,bap++)
    if (*bap!=*bp) 
    { *bvp=i; bvp++; *bvp=(unsigned)*bp; bvp++;
    }
  *bvp=0xffff;
}

void bild_recv(unsigned int i,unsigned int wert)
{ if (i==0xffff) return;
  bild_rec[i]=wert;
}

void bild_recv(int* p)
{ 
}

void bild_trans(void)
{ 
  bvp=bild_ver; unsigned int i;
  while (*bvp!=0xffff)
  { i=*bvp++;
    bild_recv(i,*bvp);
    bvp++;
  }
  bild_recv(0xffff,0xffff);
}

void bild_disp(void)
{ 
  bvp=bild_ver; unsigned int i;
  while (*bvp!=0xffff)
  { i=*bvp++;
    disp_printf(" B:%x %x ",i,*bvp);
    bvp++;
  }
}

#define TIMEOUT_BIL 20 // 1 sekunde

extern "C"  // Interruptspezifische Routinen
{
   int timeout_bil=TIMEOUT_BIL;
   volatile int comp=FALSE;
   volatile int taste=FALSE;
   unsigned int far *key_head=MK_FP(0x0040,0x001a);
   unsigned int far *key_tail=MK_FP(0x0040,0x001c);

   //****************************  
   // Interrupt-Service-Routinen   
   //****************************  

   static int isr_timer1(struct INT_DATA *id)
   {
     if (!timeout_bil--) 
     { timeout_bil=TIMEOUT_BIL;
       if (!comp) 
       { comp=TRUE;
         int_on();
         bild_comp();
         comp=FALSE;
       }
     }
     return 0; // continue interrupt chain
   } 

   static int isr_keybh(struct INT_DATA *id)
   { taste=TRUE;
     sound_click();
     return 0; // continue interrupt chain
   } 
}

void bild_init(void)
{ bild=MK_FP(0xb800,0);
  comp=TRUE;
  bp=bild; bap=bild_alt; bvp=bild_ver; 
  for (int i=0; i<BILDLEN; i++,bp++,bap++) 
    { *bap=*bp; *bvp++=i; *bvp++=*bap; }
  *bvp=0xffff;
  bild_trans();
  bp=bild; brp=bild_rec;
  for (i=0; i<BILDLEN; i++,bp++,brp++) 
    if (*bp!=*brp) disp_printf("F:%x %x ",i,*brp);  
  comp=FALSE;
}

void popmain(void)
{
}


unsigned TSR_HOTSHIFT = LSHIFT+RSHIFT;
char     TSR_HOTSCAN  = SCAN_D;
char tsr_fprint[20] = "Fingerprint";

main(int argc,char **argv)
{
        if((strncmp(argv[1],"/R",2) ==0)  || (strncmp(argv[1],"/r",2)==0))
        {
             disp_open();
             int_restore(8);
             int_restore(9);
             int i=tsr_uninstall();
             if(i==0)
                disp_printf("Program removed\n");
             if(i==2)
                disp_printf("Can not remove, Program not loaded!\n");
             if(i==3)
                disp_printf("Can not remove, Another program loaded above\n");
             disp_close();
             exit(0);
        }

        if((strncmp(argv[1],"/I",2) ==0)  || (strncmp(argv[1],"/i",2)==0))
        {
          bild_init();
          int_intercept(8,isr_timer1,128);
          int_intercept(9,isr_keybh,128);
          disp_open();
          disp_printf("Installing...Hot key is Left Shift+Right Shift+D\n");
          int i=tsr_install(POPONLY+TSR_DEBUG);
          if(i==1)
             disp_printf("Can not load, program already loaded!\n");
          else
             disp_printf("Failed to install, error %i\n",i);
          disp_close();
        }

  bild_init();
  int_intercept(8,isr_timer1,128);
  int_intercept(9,isr_keybh,128);

  unsigned int c;
  do 
  { c=bioskey(1);
    if (c) 
    { bioskey(0);
//      disp_printf("%x ",c);
    }
  }
  while ((c & 0x00ff)!=3);
  int_restore(8);
  int_restore(9);
  disp_close();
}

// END BILD_CPP
