

/* display.c */

#include <dos.h>
#include <stdio.h>

union REGS regs;

void Display (void)
{
  int far *ip;
  unsigned char far *cp;
  int i;

  /* Lesen der Equipment-Liste, entspricht der Adresse 0x410 */
  printf ("Equipment-Liste\n");
  int86 (0x11,&regs,&regs);
  switch ( (char)((regs.x.ax & 0x0030) >> 2) )
  {
    case 0x00: printf ("410:Reservierter Videomodus\n"); break;
    case 0x10: printf ("410:Farbgrafik 40x25\n");        break;
    case 0x20: printf ("410:Farbgrafik 80x25\n");        break;
    case 0x30: printf ("410:Monochromadapter 80x25\n");  break;
  }
  
  cp=MK_FP (0x0040,0x0049);
  printf ("449:aktueller Bildschirmmodus %x\n",*cp);
  
  ip=MK_FP (0x0040,0x004A);
  printf ("44A:Bildschirmbreite %x\n",*ip);
  
  ip=MK_FP (0x0040,0x004C);
  printf ("44C:Bildschirmbedarf %x\n",*ip);
  
  ip=MK_FP (0x0040,0x004E);
  printf ("44E:Bildschirmoffset  der aktuellen Seite %x\n",*ip);
  
  printf ("450-45F:Kursorposition Seite:Z/S\n");
  
  ip=MK_FP (0x0040,0x0050);
  for (i=0;i<8;i++,ip++) printf ("%i:%2x/%2x  ",i,(char)*ip,((*ip)>>4));
  printf ("\n");
  
  cp=MK_FP (0x0040,0x0060);
  printf ("460:Startrasterzeile des Kursors %x\n",*cp);
  
  cp=MK_FP (0x0040,0x0061);
  printf ("461:Endrasterzeile des Kursors %x\n",*cp);
  
  cp=MK_FP (0x0040,0x0062);
  printf ("462:Aktuelle Bildschirmseite %x\n",*cp);
  
  ip=MK_FP (0x0040,0x0063);
  printf ("463:Portadresse des Videocontrollers %3x\n",*ip);
  
  cp=MK_FP (0x0040,0x0088);
  printf ("488:Monitortyp %2x\n",*cp);
  
   switch (*cp) {
    case 0xf8: printf ("CGA\n"); break;
    case 0xf9: printf ("EGA\n"); break;
    case 0xfb: printf ("Mono\n"); break;
    default  : printf ("Unbekannt\n"); break;
  }
  
  ip=MK_FP (0x0040,0x00AA);
  printf ("4AA:Segment des Zeichensatzes %4x\n",*ip);
  ip=MK_FP (0x0040,0x00A8);
  printf ("4A8:Offset  des Zeichensatzes %4x\n",*ip);
  
  
  {
    char a;
    unsigned int seg;
    long off;
        
    /* Testen des Bildschirmspeichers */
    printf ("Bildschirmspeicher \n");
    for (seg=0xa000;((seg>=0xa000) && (seg<=0xf000));seg=seg+0x1000)
    {
      printf ("%x:",seg);
      for (off=0x0000;off<=0xe000;off=off+0x2000)
      {
        cp=MK_FP (seg,(int)off);
        a=*cp; *cp=0x55;
        printf ("%x:",off);
        if (*cp==0x55) 
        { /* es knnte ein RAM sein */
          *cp=0xaa;
          printf (""); /* dummy */
          if (*cp==0xaa) 
          {
            printf ("1 "); 
            *cp=a;
          }
          else 
            printf ("B ");
        }
        else printf ("0 ");
      }
      printf ("\n");
    }
  }
  /* gibt es ein EGA-Bios ? */
  {
    int far *ip;
    ip=MK_FP (0xc000,0);
    if (*ip==0xaa55) /* eigentlich 55aa, wegen hi-Byte zuerst umgedreht */
      printf ("EGA-Bios vorhanden\n");
    else
      printf ("kein EGA-Bios vorhanden\n");
  }
}






void main (void)
{
  Display ();
}

