

#include <stdio.h>

/**********************************************************************/
/*                               V I O S C                            */
/*--------------------------------------------------------------------*/
/*    Aufgabe        : Ermittelt die Art der installierten Video-     */
/*                     Karten und die angeschlossenen Monitore        */
/*--------------------------------------------------------------------*/
/*    Autor          : MICHAEL TISCHER                                */
/*    entwickelt am  :  2.10.1988                                     */
/*    letztes Update :  2.10.1988                                     */
/*--------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                   */
/*    Erstellung     : CL /AS /c VIOSC.C                              */
/*                     LINK VIOSC VIOSCA                              */
/*    Aufruf         : VIOSC                                          */
/*--------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                               */
/*    Erstellung     : ber Project-Datei mit folgendem Inhalt:       */
/*                     VIOSC                                          */
/*                     VIOSCA.OBJ                                     */
/**********************************************************************/
                                                                        
/*== Deklaration externer Funktionen ==================================*/
                                                                        
extern void get_vios( struct vios * );
                                                                        
/*== Typedefs ========================================================*/
                                                                        
typedef unsigned char BYTE;               /* wir basteln uns ein BYTE */
                                                                        
/*== Strukturen ======================================================*/
                                                                        
struct vios {   /* beschreibt eine Video-Karte samt angeschl. Monitor */
             BYTE karte,
                  monitor;
            };
                                                                        
/*== Konstanten ======================================================*/
                                                                        
/*-- Konstanten fr die Video-Karte ----------------------------------*/
                                                                        
#define NO_VIOS    0                    /* keine Video-Karte */
#define VGA        1                    /* VGA-Karte */
#define EGA        2                    /* EGA-Karte */
#define MDA        3                    /* Monochrome Display Adapter */
#define HGC        4                    /* Hercules Graphics Card */
#define CGA        5                    /* Color Graphics Adapter */
                                                                        
/*-- Konstanten fr den Monitor-Typ ----------------------------------*/
                                                                        
#define NO_MON     0                    /* kein Monitor */
#define MONO       1                    /* monochromer Monitor */
#define COLOR      2                    /* Color-Monitor */
#define EGA_HIRES  3                    /* hochauflsender Monitor */
#define ANAL_MONO  4                    /* monochromer Analog-Monitor */
#define ANAL_COLOR 5                    /* analoger Color-Monitor */
                                                                        
/**********************************************************************/
/**                           HAUPTPROGRAMM                          **/
/**********************************************************************/
                                                                        
void main()
                                                                        
{
 static char *vknamen[] = { /* Pointer auf die Namen der Video-Karten */
                           "VGA",
                           "EGA",
                           "MDA",
                           "HGC",
                           "CGA"
                          };
                                                                        
 static char *monnamen[] = {   /* Pointer auf Namen der Monitor-Typen */
                            "monochromen Monitor",
                            "Color-Monitor",
                            "hochauflsendem Monitor",
                            "monochromen Analog-Monitor",
                            "color Analog-Monitor"
                           };
                                                                        
 struct vios vsys[2];                          /* Vektor fr GET_VIOS */
                                                                        
 vsys[0].karte=0;
 vsys[0].monitor=0;
 vsys[1].karte=0;
 vsys[1].monitor=0;

 get_vios( vsys );                         /* Video-Systeme ermitteln */

 printf("\nVIOSC (c) 1988 by Michael Tischer\n\n");
 if ( vsys[0].karte == NO_VIOS ) 
   printf ("kein primres Video-System\n");
 else
   printf("primres Video-System:   %s-Karte an %s\n",
           vknamen[vsys[0].karte-1], monnamen[vsys[0].monitor-1]);
 if ( vsys[1].karte == NO_VIOS ) /* gibt es ein sekundres V.-System? */
   printf ("kein sekundres Video-System\n");
 else
   printf ("sekundres Video-System: %s-Karte an %s\n",
           vknamen[vsys[1].karte-1], monnamen[vsys[1].monitor-1]);
}
