/* ANSIW.C */

#include <ansiw.h>

void hlin(int row, int col, int len, int c)
{
  GOTOXY(row,col);
  while (len--)
    printf("%c",c);
}

void vlin(int row, int col, int len, int c)
{
  int r;
  for (r=0; r<len; r++)
    XYCHAR(r+row,col,c);
}

int draw(int row1, int col1, int row2, int col2, int type)
{
  int hlen, vlen; /* Breite und Hhe des Fensters */

  /* Zeichern fr die verschiedenen Rahmenpositionen */
  int hzl, /* horizontal line */
      vtl, /* vertikal line */
      ulc, /* upper left corner */
      llc, /* lower left corner */
      urc, /* upper right corner */
      lrc; /* lower right corner */

  hlen=col2-col1;
  vlen=row2-row1;

  switch (type)
  {
  case IBM_SINGLE: /* IBM-Zeichensatz, einfache Linie */
    ulc=IBM_SULC;
    llc=IBM_SLLC;
    lrc=IBM_SLRC;
    urc=IBM_SURC;
    vtl=IBM_SVTL;
    hzl=IBM_SHZL;
    break;
  case IBM_DOUBLE: /* IBM-Zeichensatz, doppelte Linie */
    ulc=IBM_DULC;
    llc=IBM_DLLC;
    lrc=IBM_DLRC;
    urc=IBM_DURC;
    vtl=IBM_DVTL;
    hzl=IBM_DHZL;
    break;
  case ASC_SINGLE: /* ASCII-Zeichensatz, einfache Linie */
    ulc=ASC_SULC;
    llc=ASC_SLLC;
    lrc=ASC_SLRC;
    urc=ASC_SURC;
    vtl=ASC_SVTL;
    hzl=ASC_SHZL;
    break;
  case ASC_DOUBLE: /* ASCII-Zeichensatz, doppelte Linie */
    ulc=ASC_DULC;
    llc=ASC_DLLC;
    lrc=ASC_DLRC;
    urc=ASC_DURC;
    vtl=ASC_DVTL;
    hzl=ASC_DHZL;
    break;
  default: /* jedes andere Zeichen wird als einheitliches
	      Rahmenzeichen angenommen */
    ulc=llc=lrc=urc=vtl=hzl=type;
    break;
  }

  if (hlen<0 || vlen<0) /* Lngenangaben waren fehlerhaft */
  {
    return (1);
  }

  if (hlen==0 && vlen==0) /* es gibt nur einen Punkt */
  {
    XYCHAR(row1,col1,ulc);
    return (0);
  }

  if (vlen==0) /* es ist eine horizontale Linie */
  {
    hlin(row1,col1,hlen,hzl);
    return (0);
  }

  if (hlen==0) /* es ist eine vertikale Linie */
  {
    vlin(row1,col1,vlen,vtl);
    return (0);
  }
  /* es ist ein Rechteck */
  hlin(row1,col1+1,hlen-1,hzl); /* obere Begrenzungslinie */
  hlin(row2,col1+1,hlen-1,hzl); /* untere Begrenzungslinie */
  vlin(row1+1,col1,vlen-1,vtl); /* linke Begrenzungslinie */
  vlin(row1+1,col2,vlen-1,vtl); /* rechte Begrenzungslinie */
  XYCHAR(row1,col1,ulc); /* linker oberer Eckpunkt */
  XYCHAR(row1,col2,urc); /* rechter oberer Eckpunkt */
  XYCHAR(row2,col2,lrc); /* rechter unterer Eckpunkt */
  XYCHAR(row2,col1,llc); /* linker unterer Eckpunkt */
  return (0);
}

int fill(int row1, int col1, int row2, int col2, int icon)
{
  int row;
  int hlen=col2-col1+1;
  int vlen=row2-row1;
  if (hlen<0 || vlen<0) /* Lngenangaben waren fehlerhaft */
  {
    return (1);
  }

  if (icon==0)  /* keine Fllung erwnscht */
    return (2);

  if (hlen==0 && vlen==0) /* es gibt nur einen Punkt */
  {
    XYCHAR(row1,col1,icon);
    return (0);
  }

  for (row=row1; row<=row2; row++)
    hlin(row,col1,hlen,icon);
  return (0);
}

/* ANSIW.C END */
