/*
 * CHIPS-Klasse
 * ============
 */
#include <chips.hpp>
#ifndef MYLIB
#include "\mylib\source\io.cpp"
#endif

CHIPS::CHIPS()
{
  address = new IOBYTE_OUT(AT_CHIPS_ADR);
  datain = new IOBYTE_IN(AT_CHIPS_DAT);
  dataout = new IOBYTE_OUT(AT_CHIPS_DAT);
  out = new IOBYTE;
  if (address && datain && dataout && out) return;
  exit (EXIT_FAILURE);
}

CHIPS::~CHIPS()
{
  delete address;
  delete datain;
  delete dataout;
  delete out;
}

UCHAR CHIPS::read(UCHAR a)
{
  UCHAR Dat;
  *address = a;
  Dat = (*datain)();
/*
*/
  out->setaddr(a);
  out->setdata(Dat);
  return Dat;
}

VOID CHIPS::write(UCHAR a, UCHAR value)
{
  *address = a;
  *dataout = value;
/*
*/
  out->setaddr(a);
  out->setdata(value);
}

VOID CHIPS::print(ostream& con)
{
  const INT COL=8;
  const INT LIN=16;

  con << "Contents of CHIP-SET" << endl;
  for (INT a=3; a<=0x13; a++)
  {
    read(a);
    con << setxy(1+COL*(a/LIN),a-(a/LIN)*LIN+2);
    con << *out;
  }
}

