/*
 * CMOS-RAM-Klasse
 * ===============
 */

#include <cmosram.h>
#ifndef MYLIB
#include "..\source\io.cpp"
#endif

CMOSRAM::CMOSRAM()
{
  address = new IOBYTE_OUT(AT_CMOS_ADR);
  datain = new IOBYTE_IN(AT_CMOS_DAT);
  dataout = new IOBYTE_OUT(AT_CMOS_DAT);
  out = new IOBYTE;
  if (address && datain && dataout && out) return;
  exit (EXIT_FAILURE);
}

CMOSRAM::~CMOSRAM()
{
  delete address;
  delete datain;
  delete dataout;
  delete out;
}

UCHAR CMOSRAM::read(UCHAR a)
{ UCHAR Dat;
  *address = a;
  Dat = (*datain)();
  out->setaddr(a);
  out->setdata(Dat);
  return Dat;
}

VOID CMOSRAM::write(UCHAR a, UCHAR value)
{
  *address = a;
  *dataout = value;
  out->setaddr(a);
  out->setdata(value);
}

UINT CMOSRAM::chksum(VOID)
{
  UINT checksum=0;
  for (INT a=0x10; a<=0x2d; a++ )
    checksum+=read(a);
  return checksum;
}

UINT CMOSRAM::chksum_read(VOID)
{
  return read(0x2e)*256+read(0x2f);
}

VOID CMOSRAM::chksum_write(UINT checksum)
{
  write(0x2e,checksum/256);
  write(0x2f,checksum-256*(checksum/256));
}

VOID CMOSRAM::print(ostream& con)
{
  const INT COL=8;
  const INT LIN=16;

  con << "Contents of CMOS-RAM" << endl;
  for (INT a=0; a<=0x7f; a++)
  {
    read(a);
    con << setxy(1+COL*(a/LIN),a-(a/LIN)*LIN+2);
    con << *out;
  }
}

