/********************************************************************/
/*         Formatted output functions.    Note: the return value    */
/*          is only good until a form function is used again.	    */
/********************************************************************/
            
#include <mylib.h>
#include <form.h>

#ifndef __STDIO_H
	#include <stdio.h>
#endif

static CHAR _form_s[256];

CHAR *dec(LONG i,INT w)
{
  sprintf(_form_s, "%*ld", w, i);
  return _form_s;
}

CHAR *hex(INT i,INT w)
{
  sprintf(_form_s, "%0*X", (w ? w : sizeof(INT)), i);
  return _form_s;
}

CHAR *hex(LONG i, INT w)
{
  sprintf(_form_s, "%0*X", (w ? w : sizeof(LONG)), i);
  return _form_s;
}

CHAR *chr(INT i,INT w)
{
  sprintf(_form_s, "%*c", w, i);
  return _form_s;
}

CHAR *form(CHAR *f,...)
{
  vsprintf(_form_s, f, ...); return _form_s;
}


