
#include <bios.h>    // bioskey()
#define P_IO
#include <portable.h>// IN_PORT
#include <iodef.h>   // PC_I_KBD
#include <keyscan.h> // SCAN_ESCAPE
#include <mylib.h>   // INT, UCHAR...

/*
 * UCHAR kbd_read(INT mode)
 * ========================
 * ENTRY: mode=0 ... wait for change on kbd-port
 *        mode=1 ... return with actual SCAN-code
 * EXIT:  returns SCAN-code
 */

INT cdecl kbd_read(INT mode)
{
  UCHAR key;
  static UCHAR oldkey=0;

  switch (mode)
  {
  case 0:
    do
      key=IN_PORT(PC_KBD_DATA);
    while (key==oldkey);
    break;
  case 1:
    key=IN_PORT(PC_KBD_DATA);
    break;
  }
  oldkey=key;
  return key;
}

/*
 * VOID clear_kbdqueue(VOID)
 * =========================
 * clears keyboard queue
 */

VOID cdecl clear_kbdqueue(VOID)
{
  while (bioskey(1)) bioskey(0);
}
