
#include <iodef.h>
#include <mylib.h>
#include <portable.h>

VOID tim0_set(UINT count)
{
  OUT_PORT(PC_TIM | TIM_CTL,0x36);
  OUT_PORT(PC_TIM | TIM_CH0,(UCHAR)count);      /* niederwertiger Teil */
  OUT_PORT(PC_TIM | TIM_CH0,(UCHAR)(count>>8)); /* hherwertiger Teil */
}

VOID tim0_init(VOID)
{
  OUT_PORT(PC_TIM|TIM_CTL,0x36);
  OUT_PORT(PC_TIM|TIM_CH2,0x00); /* Zeitkonstante niederwertiger Teil */
  OUT_PORT(PC_TIM|TIM_CH2,0x00); /* Zeitkonstante hherwertiger Teil */
}

UINT tim0_read(VOID)
{
  UINT h,l;
  l=IN_PORT(PC_TIM | TIM_CH0);
  h=IN_PORT(PC_TIM | TIM_CH0);
  return ((h<<8)+l);
}
