// fc0view.cpp : implementation of the CFc0View class
//

#include "stdafx.h"
#include "fc0.h"

#include "fc0doc.h"
#include "fc0view.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFc0View

IMPLEMENT_DYNCREATE(CFc0View, CView)

BEGIN_MESSAGE_MAP(CFc0View, CView)
	//{{AFX_MSG_MAP(CFc0View)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFc0View construction/destruction

CFc0View::CFc0View()
{     
  ButtonDown = FALSE;
  liste = new CPtrList(sizeof(CPoint));
}

CFc0View::~CFc0View()
{   
  delete liste;  
}

/////////////////////////////////////////////////////////////////////////////
// CFc0View drawing

void CFc0View::OnDraw(CDC* pDC)
{
    pDC->TextOut(100,100,"HALLO");
    pDC->MoveTo(100,100);
    pDC->LineTo(50,50);

	if (!liste->IsEmpty())
	{
	  POSITION pos;
	  for( pos = liste->GetHeadPosition(); pos != NULL; )
	  {
        CPoint *p=(CPoint*)liste->GetNext( pos );
        pDC->LineTo(*p);
	  }
	}               
}



/////////////////////////////////////////////////////////////////////////////
// CFc0View diagnostics

#ifdef _DEBUG
void CFc0View::AssertValid() const
{
	CView::AssertValid();
}

void CFc0View::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CFc0Doc* CFc0View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFc0Doc)));
	return (CFc0Doc*) m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFc0View message handlers

void CFc0View::OnLButtonDown(UINT nFlags, CPoint point)
{
    CClientDC dc(this);
    
    // char S[100];
    // sprintf(S,"(%d,%d)",point.x,point.y);
	// dc.TextOut(point.x,point.y,S);
	 
	if (!ButtonDown)
	{
	  ButtonDown = TRUE;
	  oldpoint=point;           
	  liste->AddHead(new CPoint(point));
	}
}

void CFc0View::OnLButtonUp(UINT nFlags, CPoint point)
{
	if (ButtonDown)
	{
	  ButtonDown = FALSE;   
	}
}

void CFc0View::OnMouseMove(UINT nFlags, CPoint point)
{
	if (ButtonDown)
	{
      CClientDC dc(this);
      dc.MoveTo(oldpoint);
      dc.LineTo(point);   
      oldpoint=point;
	  liste->AddHead(new CPoint(point));
	}
}

