/****************************************************************************
*                                                                           *
*                       Header File For Writing                             *
*                                                                           *
*               ATEASY Dynamic Link Library, version 1.10                   *
*                                                                           *
* Can be use with MS-C7.00/MS-QCW/MS-Visual C/C++ v1.0 or Borland C/C++ 3.1 *
*                                                                           *
*                        Version 2.00 (Jul-26-93)                           *
*                                                                           *
*                      Copyright 1991-1993 GEOTEST Inc.                     *
*                                                                           *
*                           By:  Ronnie Yazma                               *
*                                                                           *
****************************************************************************/


// include windows.h before this file 
   
/******************************************************************************
                    A T E A S Y D L . h
******************************************************************************/

/* This file contains type definition for parameters passed by ATEasy
   to a ATEasy type DLL subroutines.
   Note that ATEasy v2.0 supports also None ATEasy type DLLs which are similar to
   normal 'C' like DLL.
   This file can be used also in Non ATEasy Type DLLs if you need to use 
   the interface subroutine definition or the _CALLBACK definition. Declare
   #define _NONATEASYDLL before including this file when using in None ATEasy type
   DLLs.
       
   ATEasy type DLL 'knows' two types of subroutines:
       1) DLL subroutine that defined in the Driver Editor 'DLL Subroutines',
          this subroutine can have various parameters defined in the Variables
          Window. A general definition of that subroutine is:

          VOID _CALLBACK DLLSubroutine(hWnd [,parameters...]);

          where [,parameters...] is optional.

          Parameters definitions type are followed here, two types exist VAR
          and VAL. For example if You define an ATEASY DLL subroutine:

          Sub(VAL string A, VAL Int B, VAR Int C)

          The DLL subroutine should look like:

          VOID _CALLBACK Sub(hWnd HWND, VAL_ASTRING X, VAL_INT Y, VAR_INT Z)
          {
          }
          
          If you declare a function in ATEasy the return value is like C:
          
          String Function(VAL String A)
          
          The DLL function should declared as:
          
          LPSTR _CALLBACK Function(hWnd HWND, VAL_ASTRING A)
          {
          }           
          and the function should return a pointer to a null terminated string (ASCIIZ).

       2) Interface Sub. Defined in the Driver Editor 'Call Interface Sub'.
          This subroutine have a fixed format defined as:
          
          Return value of TRUE/FALSE tells whether ATEasy should add the command
          to the program editor.
          
          BOOL _CALLBACK InterfaceSubName(LPINTERFACEINFO);
          
          This subroutine have the same format for ATEasy DLLs and NON ATEasy type DLLs.

*/

/******************************************************************************
                    D L L   paramaters type definition
******************************************************************************/

// Use _CALLBACK when declarin a subroutine or a function,
// this will result in faster code. Also no need to add EXPORT entry in the .DEF file.

#define _CALLBACK FAR PASCAL __export

#ifndef _NONATEZDLL 

// VAL parameters type definition 

typedef char          VAL_BYTE;            // VAL Byte 
typedef short         VAL_INT;             // VAL Int  
typedef long          VAL_LONG;            // VAL Long 
typedef double        VAL_FLOAT;           // VAL Double


// VAR parameters type definition 

typedef char far *    VAR_BYTE;            // VAR Byte 
typedef short far *   VAR_INT;             // VAR Int  
typedef long far *    VAR_LONG;            // VAR Long 
typedef double far *  VAR_FLOAT;           // VAR Float


// VAL/VAR Array parameters type definition 

typedef struct tagSTRING
{   short    nLen;                         // how many bytes 
    char     sz[1];                        // buffer - conntains the bytes 
} STRING, far * LPSTRING;

typedef struct tagARRAY
{   union
    {    VAR_BYTE     lpByte;              // pointer to array of Byte
         VAR_INT      lpInt;               // pointer to array of Int 
         VAR_LONG     lpLong;              // pointer to array of Long 
         VAR_FLOAT    lpFloat;             // pointer to array of Float 
         LPSTRING     lpString;            // pointer to String [ ] 
         LPSTR        lp;                  // pointer to array - 
    } Ptr;                                 // can be use for String [ , ] 
    short    nDim1;                        // how many rows 
    short    nDim2;                        // how many cols 
} ARRAY, far *LPARRAY;

// VAL and VAR arrays are the same (when val ateasy duplicate the varaiable)
typedef LPARRAY       VAL_ABYTE, VAL_AINT, VAL_ALONG, VAL_AFLOAT, VAL_ASTRING;
typedef LPARRAY       VAR_ABYTE, VAR_AINT, VAR_ALONG, VAR_AFLOAT, VAR_ASTRING;

// 1 and 2 dim strings
#define StrLen(lpArray)         ((lpArray)->Ptr.lpString->nLen)
#define Str(lpArray)            ((lpArray)->Ptr.lpString->sz)
#define Str2D(lpArray, i)       (Str(lpArray)+(((lpArray)->nDim2+2)*(i))) 
#define Str2DLen(lpArray, i)    (*(short far *)(Str((lpArray))+(((lpArray)->nDim2+2)*(i))-2))

#endif          // _NONATEZDLL

/******************************************************************************
                   Interface Sub parameter definition
******************************************************************************/

typedef struct {
    char    szDRVName[21];                 // the name of the driver 
    short   nDRVType;                      // the type: 1-GPIB, 2-RS232, 3-VXI(MXI), 4-OTHER 
    long    lDRVAddress;                   // address handle of the driver (can be use to access low-level communication address 

    char    szCommand[511];                // the current command without parameters 
                                           // you can concate the parameters string or copy a command 
                                           // to be written to the Program Editor 
                                           
    char    szExtra[32];                   // reserved 
} FAR * LPINTERFACEINFO;

/******************************************************************************
                   E - O - F
******************************************************************************/
