{****************************************************************************
*                                                                           *
*                    Include File For Writing                               *
*                                                                           *
*             ATEASY Dynamic Link Library, version 2.00                     *
*                                                                           *
*                   for Turbo Pascal for Windows                            *
*                                                                           *
*                            June 1993                                      *
*                                                                           *
*                                                                           *
*                                                                           *
*                    Copyright 1991-1993 GEOTEST Inc.                       *
*                                                                           *
*                          By:  Ronnie Yazma                                *
*                                                                           *
****************************************************************************}

{******************************************************************************
		    A T E A S Y D L . pas
******************************************************************************}

{  This file contains type definition for parameters passed by ATEasy
   to a ATEasy type DLL subroutines.
   Note that ATEasy v2.0 supports also None ATEasy type DLLs which are similar to
   normal 'C' like DLL. When using None ATEasy type DLL include this file only
   if you plan to write an Interface Sub.
   
   ATEasy type DLL 'knows' two types of subroutines:

       1) DLL subroutine that defined in the Driver Editor 'DLL Subroutines',
          this subroutine can have various parameters defined in the Variables
          Window. A general definition of that subroutine is:

          VOID _CALLBACK DLLSubroutine(hWnd [,parameters...]);

          where [,parameters...] is optional.

          Parameters definitions type are followed here, two types exist VAR
          and VAL. For example if You define an ATEASY DLL subroutine:

          Sub(VAL string A, VAL Int B, VAR Int C)

          The DLL subroutine should look like:

          procedure Sub(HWND: hWnd; A: VAL_ASTRING; B: VAL_INT; C: VAR_INT);export;
          begin
          end;
          
          If you declare a function in ATEasy the return value is like C:
          
          String Function(VAL String A)
          
          The DLL function should declared as:
          
          function(HWND: hWnd; A: VAL_ASTRING):^char; export;
          begin
          end;

          and the function should return a pointer to a null terminated string (ASCIIZ).

       2) Interface Sub. Defined in the Driver Editor 'Call Interface Sub'.
	  This subroutine have a fixed format defined as:

	  function InterfaceSubName(lpii : LPINTERFACEINFO):integer;export;
          begin
          end;

}

{******************************************************************************
		    D L L   paramaters type definition
******************************************************************************}

type

{ VAL parameters type definition }

    VAL_BYTE  = char;
    VAL_INT   = integer;
    VAL_LONG  = longint;
    VAL_FLOAT = double;

{ VAR parameter type definition }

    VAR_BYTE  = ^char;       { Note you can use pascal keyword 'var' instead of '^'}
    VAR_INT   = ^integer;
    VAR_LONG  = ^longint;
    VAR_FLOAT = ^double;


{ VAL/VAR Array parameters type definition }

    _ABYTE = array [1..32767] of char;
    _AINT  = array [1..16383] of integer;
    _ALONG = array [1..8191] of longint;
    _AFLOAT= array [1..4095] of double;
    _ASTRING = record
            nLen : integer;
            lp   : array [1.. 32767] of char;
    end;

    _ABYTE_RECORD = record
            lpByte : ^_ABYTE;
            nDim1  : integer;
            nDim2  : integer;
    end;
    VAL_ABYTE = ^_ABYTE_RECORD;
    VAR_ABYTE = VAL_ABYTE;   { Note VAR & VAL are the same for array}

    _AINT_RECORD = record
            lpInt : ^_AINT;
            nDim1 : integer;
            nDim2 : integer;
    end;
	VAL_AINT = ^_AINT_RECORD;
    VAR_AINT = VAL_AINT;

    _ALONG_RECORD = record
            lpLong : ^_ALONG;
            nDim1  : integer;
            nDim2  : integer;
    end;
    VAL_ALONG = ^_ALONG_RECORD;
    VAR_ALONG = VAL_ALONG;

    _AFLOAT_RECORD = record
            lpFloat : ^_AFLOAT;
            nDim1   : integer;
            nDim2   : integer;
    end;
    VAL_AFLOAT = ^_AFLOAT_RECORD;
    VAR_AFLOAT = VAL_AFLOAT;

    _ASTRING_RECORD = record
            lpString : ^_ASTRING;
            nDim1    : integer;
            nDim2    : integer;
    end;
    VAL_ASTRING = ^_ASTRING_RECORD;
    VAR_ASTRING = VAL_ASTRING;


{******************************************************************************
		   Interface Sub parameter definition
******************************************************************************}

    INTERFACEINFO = record
        szDRVName   : array [1..21] of char;   { the name of the driver }
        nDRVType    : integer;                 { the type: 1-GPIB, 2-RS232, 3-VXI(MXI), 4-OTHER }
        lDRVAddress : longint;                 { address handle of the driver (can be use to access
                                                 low-level communication functions }

        szCommand   : array [1..511] of char;  { the current command without parameters }

        szExtra     : array [1..32] of char;   { reserved }
    end;
    LPINTERFACEINFO = ^INTERFACEINFO;

{******************************************************************************
		   E - O - F
******************************************************************************}
